/*
 * Decompiled with CFR 0.152.
 */
package net.jposprinter.tools;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import jpos.JposException;
import jpos.config.JposEntry;
import net.jposprinter.tools.CommandESC;
import net.jposprinter.tools.MapModeConversion;
import net.jposprinter.tools.PrinterFont;

public class CommandESCThermal
extends CommandESC {
    private boolean m_capRecFullCut = false;
    private boolean m_capRecPartialCut = false;
    private byte m_multipleHeightCommand = 0;
    private byte m_multipleWidthCommand = 0;
    private String m_QRcode = "";
    private String m_PDF417 = "";
    private MapModeConversion m_mapMode;

    public CommandESCThermal(PrinterFont var1, MapModeConversion var2, JposEntry var3) {
        super(var1, var3);
        this.m_mapMode = var2;
        this.m_capRecPartialCut = (Boolean)var3.getPropertyValue("partialCut");
        this.m_capRecFullCut = (Boolean)var3.getPropertyValue("fullCut");
    }

    @Override
    public List initializeCommand() {
        ArrayList<byte[]> outDataList = new ArrayList<byte[]>();
        outDataList.add(new byte[]{27, 116, this.m_printerFont.getCharacterSetByteCommand()});
        if (this.m_printerFont.getCapFontB()) {
            outDataList.add(new byte[]{27, 77, this.m_printerFont.getFontSelect()});
        }
        outDataList.add(new byte[]{27, 32, this.m_printerFont.getRightSideCharacterSpacing()});
        if (24 == this.m_printerFont.getDotLineSpacing()) {
            outDataList.add(new byte[]{27, 50});
        } else {
            outDataList.add(new byte[]{27, 50});
        }
        outDataList.add(new byte[]{27, 69, 0});
        outDataList.add(new byte[]{27, 45, 48});
        outDataList.add(new byte[]{29, 66, 0});
        outDataList.add(new byte[]{29, 33, 0});
        outDataList.add(new byte[]{27, 97, 48});
        return outDataList;
    }

    @Override
    public List barCodeCommand(String barcodeData, int codeType, int barHeight, int barWidth, int alignmentMode, int textPlace) throws JposException {
        byte textPlacePar;
        boolean var7 = false;
        boolean var8 = false;
        Object var13 = null;
        switch (codeType) {
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 123: 
            case 201: 
            case 204: {
                break;
            }
            default: {
                throw new JposException(106, "This request failed because the specified symbology is not supported.");
            }
        }
        byte[] barcodeDataBytes = this.getCharacterCodeBytes(barcodeData);
        ArrayList<byte[]> outDataList = new ArrayList<byte[]>();
        switch (textPlace) {
            case -11: {
                textPlacePar = 48;
                break;
            }
            case -12: {
                textPlacePar = 49;
                break;
            }
            case -13: {
                textPlacePar = 50;
                break;
            }
            case 3: 
            case 51: {
                textPlacePar = 51;
                break;
            }
            default: {
                throw new JposException(106, "This request failed because the specified text placement is not supported.");
            }
        }
        if (1 <= barHeight && 255 >= barHeight) {
            if (barWidth >= 1 && barWidth <= this.m_printerFont.getLineWidthDot()) {
                byte PDFoptions;
                byte PDFlevel2;
                byte PDFlevel1;
                byte PDFheight;
                byte PDFwidth;
                byte PDFrows;
                byte PDFcolumns;
                byte qrCodeErrorLevel;
                byte qrCodeDotUnit;
                byte barWidthType;
                byte barTypeCMD;
                block201: {
                    if (0 > this.m_printerFont.getLineWidthDot() - alignmentMode - barWidth) {
                        throw new JposException(106, "This request failed because the specified alignment is not supported.");
                    }
                    barTypeCMD = 65;
                    barWidthType = 2;
                    qrCodeDotUnit = 3;
                    qrCodeErrorLevel = 48;
                    PDFcolumns = 0;
                    PDFrows = 0;
                    PDFwidth = 3;
                    PDFheight = 3;
                    PDFlevel1 = 48;
                    PDFlevel2 = 48;
                    PDFoptions = 0;
                    if (123 != codeType && 110 != codeType) {
                        boolean var24;
                        if (101 == codeType) {
                            if (barcodeDataBytes.length != 11 && barcodeDataBytes.length != 12) {
                                throw new JposException(106, "This request failed because UPC-A barcodes require 11 or 12 data digits to be specified.");
                            }
                            barTypeCMD = 65;
                            int index = 0;
                            while (true) {
                                if (index >= barcodeDataBytes.length) {
                                    if (barWidth < 285) {
                                        var24 = true;
                                        barWidthType = 2;
                                    } else if (barWidth < 380) {
                                        var24 = true;
                                        barWidthType = 3;
                                    } else {
                                        var24 = true;
                                        barWidthType = 4;
                                    }
                                    break block201;
                                }
                                if (barcodeDataBytes[index] < 48 || barcodeDataBytes[index] > 57) {
                                    throw new JposException(106, "This request failed because UPC-A barcodes require all data digits to be between '0' and '9'.");
                                }
                                ++index;
                            }
                        }
                        if (102 == codeType) {
                            if (barcodeDataBytes.length != 11 && barcodeDataBytes.length != 12) {
                                throw new JposException(106, "This request failed because UPC-E barcodes require 11 or 12 data digits to be specified.");
                            }
                            barTypeCMD = 66;
                            for (int index = 0; index < barcodeDataBytes.length; ++index) {
                                if (barcodeDataBytes[index] >= 48 && barcodeDataBytes[index] <= 57) continue;
                                throw new JposException(106, "This request failed because UPC-E barcodes require all data digits to be between '0' and '9'.");
                            }
                            if (barWidth < 153) {
                                var24 = true;
                                barWidthType = 2;
                            } else if (barWidth < 204) {
                                var24 = true;
                                barWidthType = 3;
                            } else {
                                var24 = true;
                                barWidthType = 4;
                            }
                        } else {
                            if (103 == codeType) {
                                if (barcodeDataBytes.length != 7 && barcodeDataBytes.length != 8) {
                                    throw new JposException(106, "This request failed because JAN8 barcodes require 7 or 8 data digits to be specified.");
                                }
                                barTypeCMD = 68;
                                int index = 0;
                                while (true) {
                                    if (index >= barcodeDataBytes.length) {
                                        if (barWidth < 201) {
                                            var24 = true;
                                            barWidthType = 2;
                                        } else if (barWidth < 268) {
                                            var24 = true;
                                            barWidthType = 3;
                                        } else {
                                            var24 = true;
                                            barWidthType = 4;
                                        }
                                        break block201;
                                    }
                                    if (barcodeDataBytes[index] < 48 || barcodeDataBytes[index] > 57) {
                                        throw new JposException(106, "This request failed because JAN8 barcodes require all data digits to be between '0' and '9'.");
                                    }
                                    ++index;
                                }
                            }
                            if (104 == codeType) {
                                if (barcodeDataBytes.length != 12 && barcodeDataBytes.length != 13) {
                                    throw new JposException(106, "This request failed because JAN13 barcodes require 12 or 13 data digits to be specified.");
                                }
                                barTypeCMD = 67;
                                for (int index = 0; index < barcodeDataBytes.length; ++index) {
                                    if (barcodeDataBytes[index] >= 48 && barcodeDataBytes[index] <= 57) continue;
                                    throw new JposException(106, "This request failed because JAN13 barcodes require all data digits to be between '0' and '9'.");
                                }
                                if (barWidth < 285) {
                                    var24 = true;
                                    barWidthType = 2;
                                } else if (barWidth < 380) {
                                    var24 = true;
                                    barWidthType = 3;
                                } else {
                                    var24 = true;
                                    barWidthType = 4;
                                }
                            } else {
                                if (106 == codeType) {
                                    if (barcodeDataBytes.length < 1 || barcodeDataBytes.length > 255) {
                                        throw new JposException(106, "This request failed because ITF barcodes require between 1 and 255 data digits to be specified.");
                                    }
                                    barTypeCMD = 70;
                                    int var11 = 4;
                                    int var12 = 0;
                                    int index = 0;
                                    while (true) {
                                        if (index >= barcodeDataBytes.length) {
                                            if (barcodeDataBytes.length % 2 != 0) {
                                                var11 += 3;
                                                var12 += 2;
                                            }
                                            if (barWidth < (var11 += 2) * 2 + ++var12 * 5) {
                                                barWidth = var11 * 2 + var12 * 4;
                                                barWidthType = 2;
                                            } else if (barWidth < var11 * 2 + var12 * 6) {
                                                barWidth = var11 * 2 + var12 * 5;
                                                barWidthType = 2;
                                            } else if (barWidth < var11 * 3 + var12 * 9) {
                                                barWidth = var11 * 2 + var12 * 6;
                                                barWidthType = 2;
                                            } else if (barWidth < var11 * 4 + var12 * 8) {
                                                barWidth = var11 * 3 + var12 * 9;
                                                barWidthType = 3;
                                            } else if (barWidth < var11 * 4 + var12 * 10) {
                                                barWidth = var11 * 4 + var12 * 8;
                                                barWidthType = 4;
                                            } else if (barWidth < var11 * 4 + var12 * 12) {
                                                barWidth = var11 * 4 + var12 * 10;
                                                barWidthType = 4;
                                            } else if (barWidth < var11 * 6 + var12 * 12) {
                                                barWidth = var11 * 4 + var12 * 12;
                                                barWidthType = 4;
                                            } else if (barWidth < var11 * 6 + var12 * 15) {
                                                barWidth = var11 * 6 + var12 * 12;
                                                barWidthType = 6;
                                            } else {
                                                barWidth = var11 * 6 + var12 * 15;
                                                barWidthType = 6;
                                            }
                                            break block201;
                                        }
                                        if (barcodeDataBytes[index] < 48 || barcodeDataBytes[index] > 57) {
                                            throw new JposException(106, "This request failed because ITF barcodes require all data digits to be between '0' and '9'.");
                                        }
                                        var11 += 3;
                                        var12 += 2;
                                        ++index;
                                    }
                                }
                                if (107 == codeType) {
                                    if (barcodeDataBytes.length < 1 || barcodeDataBytes.length > 255) {
                                        throw new JposException(106, "This request failed because CodeBar-A barcodes require between 1 and 255 data digits to be specified.");
                                    }
                                    barTypeCMD = 71;
                                    int var11 = 0;
                                    int var12 = 0;
                                    block29: for (int index = 0; index < barcodeDataBytes.length; ++index) {
                                        if (barcodeDataBytes[index] >= 48 && barcodeDataBytes[index] <= 57) {
                                            var11 += 6;
                                            var12 += 2;
                                            continue;
                                        }
                                        if (barcodeDataBytes[index] >= 65 && barcodeDataBytes[index] <= 68) {
                                            var11 += 5;
                                            var12 += 3;
                                            continue;
                                        }
                                        if (barcodeDataBytes[index] >= 97 && barcodeDataBytes[index] <= 100) {
                                            var11 += 5;
                                            var12 += 3;
                                            continue;
                                        }
                                        switch (barcodeDataBytes[index]) {
                                            case 36: {
                                                var11 += 6;
                                                var12 += 2;
                                                continue block29;
                                            }
                                            case 43: {
                                                var11 += 5;
                                                var12 += 3;
                                                continue block29;
                                            }
                                            case 45: {
                                                var11 += 6;
                                                var12 += 2;
                                                continue block29;
                                            }
                                            case 46: {
                                                var11 += 5;
                                                var12 += 3;
                                                continue block29;
                                            }
                                            case 47: {
                                                var11 += 5;
                                                var12 += 3;
                                                continue block29;
                                            }
                                            case 58: {
                                                var11 += 5;
                                                var12 += 3;
                                                continue block29;
                                            }
                                            default: {
                                                throw new JposException(106, "This request failed because CodeBar-A barcodes do not support 1 or more of the specified data digits.");
                                            }
                                        }
                                    }
                                    if (barWidth < --var11 * 2 + var12 * 5) {
                                        barWidth = var11 * 2 + var12 * 4;
                                        barWidthType = 2;
                                    } else if (barWidth < var11 * 2 + var12 * 6) {
                                        barWidth = var11 * 2 + var12 * 5;
                                        barWidthType = 2;
                                    } else if (barWidth < var11 * 3 + var12 * 6) {
                                        barWidth = var11 * 2 + var12 * 6;
                                        barWidthType = 2;
                                    } else if (barWidth < var11 * 3 + var12 * 8) {
                                        barWidth = var11 * 3 + var12 * 6;
                                        barWidthType = 3;
                                    } else if (barWidth < var11 * 3 + var12 * 9) {
                                        barWidth = var11 * 3 + var12 * 8;
                                        barWidthType = 3;
                                    } else if (barWidth < var11 * 4 + var12 * 8) {
                                        barWidth = var11 * 3 + var12 * 9;
                                        barWidthType = 3;
                                    } else if (barWidth < var11 * 4 + var12 * 10) {
                                        barWidth = var11 * 4 + var12 * 8;
                                        barWidthType = 4;
                                    } else if (barWidth < var11 * 4 + var12 * 12) {
                                        barWidth = var11 * 4 + var12 * 10;
                                        barWidthType = 4;
                                    } else {
                                        barWidth = var11 * 4 + var12 * 12;
                                        barWidthType = 4;
                                    }
                                } else if (108 == codeType) {
                                    if (barcodeDataBytes.length < 1 || barcodeDataBytes.length > 255) {
                                        throw new JposException(106, "This request failed because Code39 barcodes require between 1 and 255 data digits to be specified.");
                                    }
                                    barTypeCMD = 69;
                                    int var11 = 7;
                                    int var12 = 3;
                                    for (int index = 0; index < barcodeDataBytes.length; ++index) {
                                        if (!(barcodeDataBytes[index] >= 48 && barcodeDataBytes[index] <= 57 || barcodeDataBytes[index] >= 65 && barcodeDataBytes[index] <= 90)) {
                                            switch (barcodeDataBytes[index]) {
                                                case 32: 
                                                case 36: 
                                                case 37: 
                                                case 43: 
                                                case 45: 
                                                case 46: 
                                                case 47: {
                                                    break;
                                                }
                                                default: {
                                                    throw new JposException(106, "This request failed because Code39 barcodes do not support 1 or more of the specified data digits.");
                                                }
                                            }
                                        }
                                        var11 += 7;
                                        var12 += 3;
                                    }
                                    if (barWidth < (var11 += 6) * 2 + (var12 += 3) * 5) {
                                        barWidth = var11 * 2 + var12 * 4;
                                        barWidthType = 2;
                                    } else if (barWidth < var11 * 2 + var12 * 6) {
                                        barWidth = var11 * 2 + var12 * 5;
                                        barWidthType = 2;
                                    } else if (barWidth < var11 * 3 + var12 * 6) {
                                        barWidth = var11 * 2 + var12 * 6;
                                        barWidthType = 2;
                                    } else if (barWidth < var11 * 3 + var12 * 8) {
                                        barWidth = var11 * 3 + var12 * 6;
                                        barWidthType = 3;
                                    } else if (barWidth < var11 * 3 + var12 * 9) {
                                        barWidth = var11 * 3 + var12 * 8;
                                        barWidthType = 3;
                                    } else if (barWidth < var11 * 4 + var12 * 8) {
                                        barWidth = var11 * 3 + var12 * 9;
                                        barWidthType = 3;
                                    } else if (barWidth < var11 * 4 + var12 * 10) {
                                        barWidth = var11 * 4 + var12 * 8;
                                        barWidthType = 4;
                                    } else if (barWidth < var11 * 4 + var12 * 12) {
                                        barWidth = var11 * 4 + var12 * 10;
                                        barWidthType = 4;
                                    } else {
                                        barWidth = var11 * 4 + var12 * 12;
                                        barWidthType = 4;
                                    }
                                } else if (109 == codeType) {
                                    if (barcodeDataBytes.length < 1 || barcodeDataBytes.length > 255) {
                                        throw new JposException(106, "This request failed because Code93 barcodes require between 1 and 255 data digits to be specified.");
                                    }
                                    barTypeCMD = 72;
                                    byte[] checkedBarData = null;
                                    int tempWriteIndex = 0;
                                    int var11 = 9;
                                    for (int var18 = 0; var18 < 2; ++var18) {
                                        for (int index = 0; index < barcodeDataBytes.length; ++index) {
                                            byte tempBarData = barcodeDataBytes[index];
                                            if (tempBarData < 0 || tempBarData > 127) {
                                                throw new JposException(106);
                                            }
                                            if (var18 == 0) {
                                                var11 += 9;
                                            }
                                            if (!(tempBarData == 32 || tempBarData >= 36 && tempBarData <= 37 || tempBarData == 43 || tempBarData >= 45 && tempBarData <= 47 || tempBarData >= 48 && tempBarData <= 57 || tempBarData >= 65 && tempBarData <= 90 || var18 != 0)) {
                                                var11 += 9;
                                            }
                                            if (null != checkedBarData) {
                                                checkedBarData[tempWriteIndex] = tempBarData;
                                            }
                                            ++tempWriteIndex;
                                        }
                                        if (null != checkedBarData) continue;
                                        checkedBarData = new byte[tempWriteIndex];
                                        tempWriteIndex = 0;
                                    }
                                    var11 += 9;
                                    var11 += 9;
                                    barcodeDataBytes = checkedBarData;
                                    if (barWidth < (var11 += 10) * 3) {
                                        barWidth = var11 * 2;
                                        barWidthType = 2;
                                    } else if (barWidth < var11 * 4) {
                                        barWidth = var11 * 3;
                                        barWidthType = 3;
                                    } else {
                                        barWidth = var11 * 4;
                                        barWidthType = 4;
                                    }
                                } else if (204 == codeType) {
                                    if (barcodeDataBytes.length < 4 || barcodeDataBytes.length > 2713) {
                                        throw new JposException(106, "QRCode length error !");
                                    }
                                    int index = 0;
                                    if (barcodeDataBytes[index] == 27) {
                                        if (barcodeDataBytes.length < 7 || barcodeDataBytes.length > 2713) {
                                            throw new JposException(106, "QRCode length error !");
                                        }
                                        if (barcodeDataBytes[1] < 1 || barcodeDataBytes[1] > 16) {
                                            throw new JposException(106, "QRCode dot unit error !");
                                        }
                                        if (barcodeDataBytes[2] < 48 || barcodeDataBytes[2] > 51) {
                                            throw new JposException(106, "QRCode error level error !");
                                        }
                                        byte[] checkedBarData = new byte[barcodeDataBytes.length - 3];
                                        for (index = 3; index < barcodeDataBytes.length; ++index) {
                                            if (barcodeDataBytes[index] < 32) {
                                                throw new JposException(106, "QRCode data error !");
                                            }
                                            checkedBarData[index - 3] = barcodeDataBytes[index];
                                        }
                                        qrCodeDotUnit = barcodeDataBytes[1];
                                        qrCodeErrorLevel = barcodeDataBytes[2];
                                        barcodeDataBytes = checkedBarData;
                                    } else {
                                        if (barcodeDataBytes.length > 2710) {
                                            throw new JposException(106, "QRCode length error !");
                                        }
                                        for (index = 0; index < barcodeDataBytes.length; ++index) {
                                            if (barcodeDataBytes[index] >= 32) continue;
                                            throw new JposException(106, "QRCode data error !");
                                        }
                                        qrCodeDotUnit = 3;
                                        qrCodeErrorLevel = 48;
                                    }
                                } else {
                                    if (201 != codeType) {
                                        throw new JposException(106, "This request failed because the specified symbology is not supported.");
                                    }
                                    int index = 0;
                                    if (barcodeDataBytes[index++] == 27) {
                                        if (barcodeDataBytes.length < 12 || barcodeDataBytes.length > 2718) {
                                            throw new JposException(106, "PDF417 length error !");
                                        }
                                        if ((PDFcolumns = barcodeDataBytes[index++]) < 0 || PDFcolumns > 30) {
                                            throw new JposException(106, "PDF417 PDFcolumns error !");
                                        }
                                        if (((PDFrows = barcodeDataBytes[index++]) < 3 || PDFrows > 9) && PDFrows != 0) {
                                            throw new JposException(106, "PDF417 PDFrows error !");
                                        }
                                        if ((PDFwidth = barcodeDataBytes[index++]) < 2 || PDFwidth > 8) {
                                            throw new JposException(106, "PDF417 PDFwidth error !");
                                        }
                                        if ((PDFheight = barcodeDataBytes[index++]) < 2 || PDFheight > 8) {
                                            throw new JposException(106, "PDF417 PDFheight error !");
                                        }
                                        if ((PDFlevel1 = barcodeDataBytes[index++]) == 48) {
                                            if ((PDFlevel2 = barcodeDataBytes[index++]) < 48 || PDFlevel2 > 56) {
                                                throw new JposException(106, "PDF417 PDFlevel2 error !");
                                            }
                                        } else if (PDFlevel1 != 49) {
                                            if ((PDFlevel2 = barcodeDataBytes[index++]) < 1 || PDFlevel2 > 40) {
                                                throw new JposException(106, "PDF417 PDFlevel2 error !");
                                            }
                                        } else {
                                            throw new JposException(106, "PDF417 PDFlevel1 error !");
                                        }
                                        if ((PDFoptions = barcodeDataBytes[index++]) < 0 || PDFoptions > 1) {
                                            throw new JposException(106, "PDF417 PDFoptions error !");
                                        }
                                        byte[] checkedBarData = new byte[barcodeDataBytes.length - index];
                                        int var11 = 0;
                                        while (index < barcodeDataBytes.length) {
                                            checkedBarData[var11++] = barcodeDataBytes[index];
                                            ++index;
                                        }
                                        barcodeDataBytes = checkedBarData;
                                    } else {
                                        if (barcodeDataBytes.length < 4 || barcodeDataBytes.length > 2710) {
                                            throw new JposException(106, "PDF417 length error !");
                                        }
                                        PDFcolumns = 0;
                                        PDFrows = 0;
                                        PDFwidth = 3;
                                        PDFheight = 3;
                                        PDFlevel1 = 48;
                                        PDFlevel2 = 48;
                                        PDFoptions = 0;
                                    }
                                }
                            }
                        }
                    } else {
                        if (barcodeDataBytes.length < 1 || barcodeDataBytes.length > 255) {
                            throw new JposException(106);
                        }
                        byte[] checkedBarData = null;
                        int tempWriteIndex = 0;
                        barTypeCMD = 73;
                        barWidthType = 2;
                        int var18 = 0;
                        while (true) {
                            if (var18 >= 2) {
                                barcodeDataBytes = checkedBarData;
                                break;
                            }
                            boolean isShit = false;
                            for (int index = 0; index < barcodeDataBytes.length; ++index) {
                                byte barData = barcodeDataBytes[index];
                                if (!isShit) {
                                    if (barData == 123) {
                                        isShit = true;
                                        continue;
                                    }
                                    if (barData < 0 || barData > 127) {
                                        throw new JposException(106);
                                    }
                                    if (barData >= 0 && barData <= 31) {
                                        if (null != checkedBarData) {
                                            checkedBarData[tempWriteIndex] = 37;
                                        }
                                        ++tempWriteIndex;
                                        if (null != checkedBarData) {
                                            checkedBarData[tempWriteIndex] = (byte)(64 + barData);
                                        }
                                        ++tempWriteIndex;
                                        continue;
                                    }
                                    if (barData == 37) {
                                        if (null != checkedBarData) {
                                            checkedBarData[tempWriteIndex] = 37;
                                        }
                                        ++tempWriteIndex;
                                        if (null != checkedBarData) {
                                            checkedBarData[tempWriteIndex] = 48;
                                        }
                                        ++tempWriteIndex;
                                        continue;
                                    }
                                    if (barData == 127) {
                                        if (null != checkedBarData) {
                                            checkedBarData[tempWriteIndex] = 37;
                                        }
                                        ++tempWriteIndex;
                                        if (null != checkedBarData) {
                                            checkedBarData[tempWriteIndex] = 53;
                                        }
                                        ++tempWriteIndex;
                                        continue;
                                    }
                                    if (null != checkedBarData) {
                                        checkedBarData[tempWriteIndex] = barData;
                                    }
                                    ++tempWriteIndex;
                                    continue;
                                }
                                if (null != checkedBarData) {
                                    checkedBarData[tempWriteIndex] = 123;
                                }
                                ++tempWriteIndex;
                                if (null != checkedBarData) {
                                    checkedBarData[tempWriteIndex] = barData;
                                }
                                ++tempWriteIndex;
                                isShit = false;
                            }
                            if (null == checkedBarData) {
                                checkedBarData = new byte[tempWriteIndex];
                                tempWriteIndex = 0;
                            }
                            ++var18;
                        }
                    }
                }
                if (1 == this.getRotateSpecial()) {
                    outDataList.add(new byte[]{27, 123, 0});
                } else {
                    outDataList.add(new byte[]{27, 123, 1});
                }
                this.addArrayListElementsLast(this.initializeCommand(), outDataList);
                byte[] cmdAlignment = new byte[]{27, 97, 0};
                switch (alignmentMode) {
                    case -2: {
                        cmdAlignment[2] = 1;
                        break;
                    }
                    case -3: {
                        cmdAlignment[2] = 2;
                        break;
                    }
                }
                outDataList.add(cmdAlignment);
                if (204 == codeType) {
                    if (!this.m_QRcode.equals(barcodeData)) {
                        outDataList.add(new byte[]{29, 40, 107, 48, 103, qrCodeDotUnit});
                        outDataList.add(new byte[]{29, 40, 107, 48, 105, qrCodeErrorLevel});
                        outDataList.add(new byte[]{29, 40, 107, 48, -128, (byte)(barcodeDataBytes.length % 256), (byte)(barcodeDataBytes.length / 256)});
                        outDataList.add(barcodeDataBytes);
                        this.m_QRcode = barcodeData;
                    }
                    if (-12 == textPlace) {
                        outDataList.add(barcodeDataBytes);
                        outDataList.add(new byte[]{13, 10});
                    }
                    outDataList.add(new byte[]{29, 40, 107, 48, -127, 10});
                    if (-13 == textPlace) {
                        outDataList.add(barcodeDataBytes);
                        outDataList.add(new byte[]{13, 10});
                    }
                } else if (201 == codeType) {
                    if (!this.m_PDF417.equals(barcodeData)) {
                        outDataList.add(new byte[]{29, 40, 107, 3, 0, 48, 65, PDFcolumns});
                        outDataList.add(new byte[]{29, 40, 107, 3, 0, 48, 66, PDFrows});
                        outDataList.add(new byte[]{29, 40, 107, 3, 0, 48, 67, PDFwidth});
                        outDataList.add(new byte[]{29, 40, 107, 3, 0, 48, 68, PDFheight});
                        outDataList.add(new byte[]{29, 40, 107, 4, 0, 48, 69, PDFlevel1, PDFlevel2});
                        outDataList.add(new byte[]{29, 40, 107, 3, 0, 48, 70, PDFoptions});
                        outDataList.add(new byte[]{29, 40, 107, (byte)((barcodeDataBytes.length + 3) % 256), (byte)((barcodeDataBytes.length + 3) / 256), 48, 80, 48});
                        outDataList.add(barcodeDataBytes);
                        this.m_PDF417 = barcodeData;
                    }
                    outDataList.add(new byte[]{29, 40, 107, 3, 0, 48, 81, 48, 10});
                } else {
                    outDataList.add(new byte[]{29, 72, textPlacePar});
                    outDataList.add(new byte[]{29, 119, barWidthType});
                    outDataList.add(new byte[]{29, 104, (byte)barHeight});
                    outDataList.add(new byte[]{29, 107, barTypeCMD, (byte)barcodeDataBytes.length});
                    outDataList.add(barcodeDataBytes);
                }
                outDataList.add(new byte[]{27, 97, 0});
                outDataList.add(new byte[]{27, 36, 0, 0});
                return outDataList;
            }
            throw new JposException(106, "This request failed because the specified width is not supported.");
        }
        throw new JposException(106, "This request failed because the specified height is not supported.");
    }

    @Override
    public byte[] paperCutCommand(int var1, boolean var2, boolean var3) throws JposException {
        byte[] var4 = new byte[]{29, 86, 0, 0};
        if (100 < var1) {
            var4[2] = var2 ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 65) : 0;
        } else {
            if (0 > var1) {
                throw new JposException(106, "This request is illegal");
            }
            if (100 == var1) {
                var4[2] = var2 ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 65) : 0;
            } else if (0 == var1) {
                if (var2) {
                    if (!this.m_capRecPartialCut && !this.m_capRecFullCut) {
                        var4[2] = 116;
                    } else {
                        var4[1] = 97;
                        var4[2] = 1 > this.m_printerFont.getRecLinesToPaperCut() ? 1 : (127 < this.m_printerFont.getRecLinesToPaperCut() ? 127 : (byte)this.m_printerFont.getRecLinesToPaperCut());
                    }
                }
            } else {
                var4[2] = var2 ? (!this.m_capRecPartialCut && !this.m_capRecFullCut ? 116 : 66) : 1;
            }
        }
        return var4;
    }

    @Override
    protected void multipleHeightSetting(int var1, boolean var2) throws JposException {
        if (1 > var1) {
            if (var2) {
                throw new JposException(106, "This request is illegal and print with the normal height.");
            }
            this.m_multipleHeightCommand = 0;
        } else if (8 < var1) {
            if (var2) {
                throw new JposException(106, "This request is illegal and print with the height scaled 6 times the normal size.");
            }
            this.m_multipleHeightCommand = (byte)7;
        } else {
            this.m_multipleHeightCommand = (byte)(var1 - 1);
        }
    }

    @Override
    protected void multipleWidthSetting(int var1, boolean var2) throws JposException {
        if (1 > var1) {
            if (var2) {
                throw new JposException(106, "This request is illegal and set character size to normal.");
            }
            this.m_multipleWidthCommand = 0;
        } else if (8 < var1) {
            if (var2) {
                throw new JposException(106, "This request is illegal and set character size to 6 width.");
            }
            this.m_multipleWidthCommand = (byte)7;
        } else {
            this.m_multipleWidthCommand = (byte)(var1 - 1);
        }
    }

    @Override
    protected byte[] multipleHeightAndWidthCommand() throws JposException {
        return new byte[]{29, 33, (byte)(this.m_multipleWidthCommand * 16 + this.m_multipleHeightCommand)};
    }

    @Override
    protected byte[] feedUnitsCommand(int var1, boolean var2) throws JposException {
        int var3 = this.m_mapMode.mapModeToDotHeight(var1);
        var3 = 0 != var3 % 2 ? var3 / 2 + 1 : (var3 /= 2);
        if (1 > var3) {
            if (var2) {
                throw new JposException(106, "This request is illegal and feed 1 dot.");
            }
            var3 = 1;
        } else if (255 < var3) {
            if (var2) {
                throw new JposException(106, "This request is illegal and feed 255 dots.");
            }
            var3 = 255;
        }
        return new byte[]{27, 100, (byte)var3};
    }

    @Override
    protected byte[] feedReverseCommand(int var1, boolean var2) throws JposException {
        if (var2) {
            throw new JposException(106, "This request failed because this request is not supported this print station.");
        }
        return null;
    }

    @Override
    public List bitmapCommand(Image srcImage, int dotWidth, int aligmentMode, int upSide) throws JposException {
        byte[] bmpDataArray;
        int imageHeight;
        boolean var5 = false;
        BufferedImage editImage = null;
        List outDataList = null;
        outDataList = this.initializeCommand();
        this.addArrayListElementsFirst(this.headerCommand(), outDataList);
        try {
            if (dotWidth != -11) {
                srcImage = new ImageIcon(srcImage.getScaledInstance(dotWidth, -1, 1)).getImage();
            }
            dotWidth = srcImage.getWidth(null);
            imageHeight = srcImage.getHeight(null);
        }
        catch (Exception var15) {
            throw new JposException(114, 207);
        }
        if (dotWidth <= 0) {
            throw new JposException(106, "This request failed because the bitmap width is 0.");
        }
        if (dotWidth > this.m_printerFont.getLineWidthDot()) {
            throw new JposException(114, 206);
        }
        if (0 > this.m_printerFont.getLineWidthDot() - aligmentMode - dotWidth) {
            throw new JposException(106, "This request failed because the aligment parameter is not valid.");
        }
        if (aligmentMode == -1) {
            aligmentMode = 0;
        } else if (aligmentMode == -2) {
            aligmentMode = (this.m_printerFont.getLineWidthDot() - dotWidth) / 2;
        } else if (aligmentMode == -3) {
            aligmentMode = this.m_printerFont.getLineWidthDot() - dotWidth;
        }
        if (imageHeight <= 0) {
            throw new JposException(106, "This request failed because the bitmap height is 0.");
        }
        try {
            editImage = new BufferedImage(srcImage.getWidth(null), srcImage.getHeight(null), 1);
            Graphics2D graphics = editImage.createGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, srcImage.getWidth(null), srcImage.getHeight(null));
            graphics.drawImage(srcImage, 0, 0, null);
            graphics.dispose();
        }
        catch (Exception var13) {
            throw new JposException(114, 207);
        }
        boolean var17 = false;
        int bmpDataIndexStar = 0;
        try {
            int bmpDataArrayLength = this.m_printerFont.getLineWidthDot() - aligmentMode - dotWidth - 1 > 0 ? (imageHeight % 24 != 0 ? 3 + (9 + dotWidth * 3 + 4 + 3) * (imageHeight / 24 + 1) : 3 + (9 + dotWidth * 3 + 4 + 3) * (imageHeight / 24)) : (imageHeight % 24 != 0 ? 3 + (9 + dotWidth * 3 + 3) * (imageHeight / 24 + 1) : 3 + (9 + dotWidth * 3 + 3) * (imageHeight / 24));
            bmpDataArray = new byte[bmpDataArrayLength];
            int n = bmpDataIndexStar;
            bmpDataIndexStar = (byte)(bmpDataIndexStar + 1);
            bmpDataArray[n] = 27;
            int n2 = bmpDataIndexStar;
            bmpDataIndexStar = (byte)(bmpDataIndexStar + 1);
            bmpDataArray[n2] = 123;
            if (1 == upSide) {
                int n3 = bmpDataIndexStar;
                bmpDataIndexStar = (byte)(bmpDataIndexStar + 1);
                bmpDataArray[n3] = 0;
            } else {
                int n4 = bmpDataIndexStar;
                bmpDataIndexStar = (byte)(bmpDataIndexStar + 1);
                bmpDataArray[n4] = 1;
            }
            int writeIndex = bmpDataIndexStar;
            for (int indexHeight = 0; indexHeight < imageHeight; indexHeight += 24) {
                int indexWidth;
                bmpDataArray[writeIndex++] = 27;
                bmpDataArray[writeIndex++] = 36;
                bmpDataArray[writeIndex++] = (byte)(aligmentMode % 256);
                bmpDataArray[writeIndex++] = (byte)(aligmentMode / 256);
                bmpDataArray[writeIndex++] = 27;
                bmpDataArray[writeIndex++] = 42;
                bmpDataArray[writeIndex++] = 33;
                bmpDataArray[writeIndex++] = (byte)(dotWidth % 256);
                bmpDataArray[writeIndex++] = (byte)(dotWidth / 256);
                if (1 == upSide) {
                    indexWidth = 0;
                    while (indexWidth < dotWidth) {
                        switch (imageHeight - indexHeight) {
                            default: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 23))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 1);
                                }
                            }
                            case 23: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 22))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 2);
                                }
                            }
                            case 22: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 21))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 4);
                                }
                            }
                            case 21: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 20))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 8);
                                }
                            }
                            case 20: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 19))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 0x10);
                                }
                            }
                            case 19: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 18))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 0x20);
                                }
                            }
                            case 18: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 17))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 0x40);
                                }
                            }
                            case 17: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 16))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 0x80);
                                }
                            }
                            case 16: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 15))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 1);
                                }
                            }
                            case 15: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 14))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 2);
                                }
                            }
                            case 14: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 13))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 4);
                                }
                            }
                            case 13: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 12))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 8);
                                }
                            }
                            case 12: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 11))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 0x10);
                                }
                            }
                            case 11: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 10))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 0x20);
                                }
                            }
                            case 10: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 9))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 0x40);
                                }
                            }
                            case 9: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 8))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 0x80);
                                }
                            }
                            case 8: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 7))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 1);
                                }
                            }
                            case 7: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 6))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 2);
                                }
                            }
                            case 6: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 5))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 4);
                                }
                            }
                            case 5: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 4))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 8);
                                }
                            }
                            case 4: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 3))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 0x10);
                                }
                            }
                            case 3: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 2))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 0x20);
                                }
                            }
                            case 2: {
                                if (!this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight + 1))) break;
                                bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 0x40);
                            }
                            case 1: 
                        }
                        if (this.convertColor2Mono(editImage.getRGB(indexWidth, indexHeight))) {
                            bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 0x80);
                        }
                        ++indexWidth;
                        writeIndex += 3;
                    }
                } else if (259 == upSide) {
                    indexWidth = 0;
                    while (indexWidth < dotWidth) {
                        switch (imageHeight - indexHeight) {
                            default: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 24))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 0x80);
                                }
                            }
                            case 23: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 23))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 0x40);
                                }
                            }
                            case 22: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 22))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 0x20);
                                }
                            }
                            case 21: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 21))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 0x10);
                                }
                            }
                            case 20: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 20))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 8);
                                }
                            }
                            case 19: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 19))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 4);
                                }
                            }
                            case 18: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 18))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 2);
                                }
                            }
                            case 17: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 17))) {
                                    bmpDataArray[writeIndex] = (byte)(bmpDataArray[writeIndex] | 1);
                                }
                            }
                            case 16: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 16))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 0x80);
                                }
                            }
                            case 15: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 15))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 0x40);
                                }
                            }
                            case 14: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 14))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 0x20);
                                }
                            }
                            case 13: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 13))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 0x10);
                                }
                            }
                            case 12: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 12))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 8);
                                }
                            }
                            case 11: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 11))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 4);
                                }
                            }
                            case 10: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 10))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 2);
                                }
                            }
                            case 9: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 9))) {
                                    bmpDataArray[writeIndex + 1] = (byte)(bmpDataArray[writeIndex + 1] | 1);
                                }
                            }
                            case 8: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 8))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 0x80);
                                }
                            }
                            case 7: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 7))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 0x40);
                                }
                            }
                            case 6: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 6))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 0x20);
                                }
                            }
                            case 5: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 5))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 0x10);
                                }
                            }
                            case 4: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 4))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 8);
                                }
                            }
                            case 3: {
                                if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 3))) {
                                    bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 4);
                                }
                            }
                            case 2: {
                                if (!this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 2))) break;
                                bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 2);
                            }
                            case 1: 
                        }
                        if (this.convertColor2Mono(editImage.getRGB(indexWidth, imageHeight - indexHeight - 1))) {
                            bmpDataArray[writeIndex + 2] = (byte)(bmpDataArray[writeIndex + 2] | 1);
                        }
                        ++indexWidth;
                        writeIndex += 3;
                    }
                }
                if (this.m_printerFont.getLineWidthDot() - aligmentMode - dotWidth - 1 > 0) {
                    bmpDataArray[writeIndex++] = 27;
                    bmpDataArray[writeIndex++] = 92;
                    bmpDataArray[writeIndex++] = (byte)((this.m_printerFont.getLineWidthDot() - aligmentMode - dotWidth - 1) % 256);
                    bmpDataArray[writeIndex++] = (byte)((this.m_printerFont.getLineWidthDot() - aligmentMode - dotWidth - 1) / 256);
                }
                bmpDataArray[writeIndex++] = 27;
                bmpDataArray[writeIndex++] = 74;
                bmpDataArray[writeIndex++] = 24;
            }
        }
        catch (Exception var14) {
            throw new JposException(114, 207);
        }
        outDataList.add(bmpDataArray);
        return outDataList;
    }
}

