/*
 * Decompiled with CFR 0.152.
 */
package net.jposprinter.printerio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Vector;
import net.jposprinter.printerio.IOPortException;
import net.jposprinter.printerio.PrinterStatus;
import sun.net.util.IPAddressUtil;

public class IOPort {
    private static final int iCoverOpen = 0;
    private static final int iOffline = 1;
    private static final int iCutterError = 2;
    private static final int iHeadThermistorError = 3;
    private static final int iReceiveBufferOverflow = 4;
    private static final int iReceiptPaperEmpty = 5;
    private static final int iReceiptPaperNearEmptyInner = 6;
    private static final int iStackerFull = 7;
    private static final int iRawLength = 8;
    private static final int iRaw = 9;
    private static final int USB_PORT = 1;
    private static final int COM_PORT = 2;
    private static final int NET_PORT = 3;
    private static final int LPT_PORT = 4;
    private static final byte BAUD_9600 = 1;
    private static final byte BAUD_19200 = 2;
    private static final byte BAUD_38400 = 3;
    private static final byte BAUD_115200 = 4;
    private final String m_portName;
    private final String m_portSettings;
    private int m_nativePort;
    private int m_usageCount;
    private static boolean s_classServicesReadied = false;
    private static final Vector s_ports;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized IOPort getPort(String paramString1, String paramString2, int paramInt) throws IOPortException {
        if (!s_classServicesReadied) {
            throw new IOPortException("The required native libraries  & class services are not available.");
        }
        for (int i = 0; i < s_ports.size(); ++i) {
            IOPort localIOPort2 = (IOPort)s_ports.get(i);
            if (!localIOPort2.m_portName.equals(paramString1)) continue;
            if (localIOPort2.m_portSettings.equals(paramString2)) {
                IOPort iOPort = localIOPort2;
                synchronized (iOPort) {
                    ++localIOPort2.m_usageCount;
                    return localIOPort2;
                }
            }
            throw new IOPortException("This port is already opened and is configured with different settings.");
        }
        IOPort localIOPort1 = new IOPort(paramString1, paramString2, paramInt);
        s_ports.add(localIOPort1);
        return localIOPort1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void releasePort(IOPort paramIOPort) {
        for (int i = 0; i < s_ports.size(); ++i) {
            IOPort localIOPort = (IOPort)s_ports.get(i);
            if (localIOPort != paramIOPort) continue;
            IOPort iOPort = localIOPort;
            synchronized (iOPort) {
                if (--localIOPort.m_usageCount == 0) {
                    localIOPort.closeNative();
                    s_ports.remove(localIOPort);
                }
                break;
            }
        }
    }

    public synchronized String getPortName() {
        return this.m_portName;
    }

    public synchronized String getPortSettings() {
        return this.m_portSettings;
    }

    public synchronized int writePort(byte[] paramArrayOfByte, int paramInt1, int paramInt2) throws IOPortException {
        if ((long)this.m_nativePort == 0L) {
            throw new IOPortException("This port has been closed.");
        }
        int[] arrayOfInt = new int[1];
        if (IOPort.nativeWritePortEx(this.m_nativePort, paramArrayOfByte, paramInt1, paramInt2, arrayOfInt) == 0) {
            throw new IOPortException("The native writePort function failed.");
        }
        return arrayOfInt[0];
    }

    public synchronized int readPort(byte[] paramArrayOfByte, int paramInt1, int paramInt2) throws IOPortException {
        if ((long)this.m_nativePort == 0L) {
            throw new IOPortException("This port has been closed.");
        }
        int[] arrayOfInt = new int[1];
        if (IOPort.nativeReadPortEx(this.m_nativePort, paramArrayOfByte, paramInt1, paramInt2, arrayOfInt) == 0) {
            throw new IOPortException("The native readPort function failed.");
        }
        return arrayOfInt[0];
    }

    public synchronized PrinterStatus retreiveStatus() throws IOPortException {
        if ((long)this.m_nativePort == 0L) {
            throw new IOPortException("This port has been closed.");
        }
        PrinterStatus localPrinterStatus = new PrinterStatus();
        if (IOPort.nativeGetParsedStatusEx(this.m_nativePort, localPrinterStatus) == 0) {
            throw new IOPortException("The native retreiveStatus function failed.");
        }
        return localPrinterStatus;
    }

    public synchronized void resetDevice() throws IOPortException {
        if ((long)this.m_nativePort == 0L) {
            throw new IOPortException("This port has been closed.");
        }
        if (IOPort.nativeResetDeviceEx(this.m_nativePort) == 0) {
            throw new IOPortException("The native resetDevice function failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void cleanupAllOpenPorts() {
        for (int i = 0; i < s_ports.size(); ++i) {
            IOPort localIOPort;
            IOPort iOPort = localIOPort = (IOPort)s_ports.get(i);
            synchronized (iOPort) {
                localIOPort.closeNative();
                continue;
            }
        }
    }

    private IOPort(String paramString1, String paramString2, int paramInt) throws IOPortException {
        this.m_portName = paramString1;
        this.m_portSettings = paramString2;
        this.m_nativePort = IOPort.nativeOpenPortEx(this.m_portName, this.m_portSettings, paramInt);
        if ((long)this.m_nativePort == 0L) {
            throw new IOPortException(false, "The native OpenPort function failed.");
        }
        this.m_usageCount = 1;
    }

    protected void finalize() throws Throwable {
        this.closeNative();
        super.finalize();
    }

    private void closeNative() {
        if (this.m_nativePort != 0) {
            IOPort.nativeClosePortEx(this.m_nativePort);
            this.m_nativePort = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isInstalledLibraryBinarySame(String paramString) {
        FileInputStream localFileInputStream = null;
        InputStream localInputStream = null;
        try {
            localFileInputStream = new FileInputStream(new File(System.getProperty("java.io.tmpdir") + "/" + paramString));
            byte[] arrayOfByte1 = new byte[10240];
            localInputStream = IOPort.class.getClassLoader().getResource("net/JposPrinter/printerio/natives/" + paramString).openStream();
            byte[] arrayOfByte2 = new byte[10240];
            block32: while (true) {
                int i;
                if ((i = localFileInputStream.read(arrayOfByte1)) <= 0) {
                    boolean bl;
                    if (localInputStream.read(arrayOfByte2) > 0) {
                        bl = false;
                        return bl;
                    }
                    bl = true;
                    return bl;
                }
                int k = 0;
                while (true) {
                    if (i <= 0) continue block32;
                    int j = localInputStream.read(arrayOfByte2, 0, i);
                    if (j <= 0) {
                        boolean bl = false;
                        return bl;
                    }
                    i -= j;
                    for (int m = 0; m < j; ++m) {
                        if (arrayOfByte1[k + m] == arrayOfByte2[m]) continue;
                        boolean bl = false;
                        return bl;
                    }
                    k += j;
                }
                break;
            }
        }
        catch (Exception localException1) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (localFileInputStream != null) {
                    localFileInputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (localInputStream != null) {
                    localInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String installNativeLibrary(String paramString) throws Exception {
        InputStream localInputStream = null;
        FileOutputStream localFileOutputStream = null;
        try {
            int i;
            localInputStream = IOPort.class.getClassLoader().getResource("net/JposPrinter/printerio/natives/" + paramString).openStream();
            String str1 = System.getProperty("java.io.tmpdir") + "/" + paramString;
            File localFile = new File(str1);
            localFile.delete();
            localFileOutputStream = new FileOutputStream(localFile);
            byte[] arrayOfByte = new byte[10240];
            while ((i = localInputStream.read(arrayOfByte)) > 0) {
                localFileOutputStream.write(arrayOfByte, 0, i);
            }
            String string = str1;
            return string;
        }
        finally {
            if (localInputStream != null) {
                localInputStream.close();
            }
            if (localFileOutputStream != null) {
                localFileOutputStream.close();
            }
        }
    }

    private static final String mapLibraryName(String paramString) {
        if (System.getProperty("os.name").equals("Mac OS X")) {
            return "lib" + paramString + ".dylib";
        }
        return System.mapLibraryName(paramString);
    }

    private static final String getOsName() {
        return System.getProperty("os.name");
    }

    private static final String getOsArch() {
        return System.getProperty("os.arch");
    }

    private static final String getJavaArch() {
        return System.getProperty("sun.arch.data.model");
    }

    private static int nativeOpenPortEx(String portName, String portSettings, int timeOut) {
        int port = 0;
        byte[] portSet = new byte[10];
        block11 : switch (portName.substring(0, 1)) {
            case "t": 
            case "T": {
                port = 3;
                byte[] ip = IPAddressUtil.textToNumericFormatV4(portName.substring(4));
                if (ip.length != 4) {
                    return 0;
                }
                portSet[0] = ip[0];
                portSet[1] = ip[1];
                portSet[2] = ip[2];
                portSet[3] = ip[3];
                break;
            }
            case "L": 
            case "l": {
                port = 4;
                break;
            }
            case "C": 
            case "c": {
                port = 2;
                if (portName.length() > 5 || portName.length() < 4) {
                    return 0;
                }
                try {
                    portSet[0] = Byte.parseByte(portName.substring(3));
                }
                catch (Exception ex) {
                    return 0;
                }
                switch (portSettings) {
                    case "9600": {
                        portSet[1] = 1;
                        break block11;
                    }
                    case "19200": {
                        portSet[1] = 2;
                        break block11;
                    }
                    case "38400": {
                        portSet[1] = 3;
                        break block11;
                    }
                    case "115200": {
                        portSet[1] = 4;
                        break block11;
                    }
                }
                return 0;
            }
            case "u": 
            case "U": {
                port = 1;
                break;
            }
            default: {
                port = 4;
                portSet[0] = 1;
            }
        }
        return IOPort.nativeOpenPort(port, portSet, timeOut);
    }

    private static int nativeClosePortEx(int paramLong) {
        return IOPort.nativeClosePort(paramLong);
    }

    private static int nativeReadPortEx(int paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt) {
        return IOPort.nativeReadPort(paramLong, paramArrayOfByte, paramInt1, paramInt2, paramArrayOfInt);
    }

    private static int nativeWritePortEx(int paramLong, byte[] paramArrayOfByte, int paramInt1, int paramInt2, int[] paramArrayOfInt) {
        return IOPort.nativeWritePort(paramLong, paramArrayOfByte, paramInt1, paramInt2, paramArrayOfInt);
    }

    private static int nativeGetParsedStatusEx(int paramLong, PrinterStatus paramPrinterStatus) {
        paramPrinterStatus.InitParams();
        byte[] statusBuffer = new byte[64];
        statusBuffer[0] = 22;
        if (IOPort.nativeGetParsedStatus(paramLong, statusBuffer) == 0) {
            return 0;
        }
        if (statusBuffer[0] == 1) {
            paramPrinterStatus.coverOpen = true;
        }
        if (statusBuffer[2] == 1) {
            paramPrinterStatus.cutterError = true;
        }
        if (statusBuffer[1] == 1) {
            paramPrinterStatus.offline = true;
        }
        if (statusBuffer[3] == 1) {
            paramPrinterStatus.headThermistorError = true;
        }
        if (statusBuffer[5] == 1) {
            paramPrinterStatus.receiptPaperEmpty = true;
        }
        if (statusBuffer[4] == 1) {
            paramPrinterStatus.receiveBufferOverflow = true;
        }
        if (statusBuffer[6] == 1) {
            paramPrinterStatus.receiptPaperNearEmptyInner = true;
        }
        if (statusBuffer[7] == 1) {
            paramPrinterStatus.stackerFull = true;
        }
        if (statusBuffer[8] != 0) {
            paramPrinterStatus.rawLength = statusBuffer[8];
        }
        for (int i = 0; i < statusBuffer[8]; ++i) {
            paramPrinterStatus.raw[i] = statusBuffer[i + 9];
        }
        return 1;
    }

    private static int nativeResetDeviceEx(int paramLong) {
        return IOPort.nativeResetDevice(paramLong);
    }

    private static final native int nativeOpenPort(int var0, byte[] var1, int var2);

    private static final native int nativeClosePort(int var0);

    private static final native int nativeReadPort(int var0, byte[] var1, int var2, int var3, int[] var4);

    private static final native int nativeWritePort(int var0, byte[] var1, int var2, int var3, int[] var4);

    private static final native int nativeGetParsedStatus(int var0, byte[] var1);

    private static final native int nativeResetDevice(int var0);

    public static int testIOPort(String portName, String portSetting, int timeOut) {
        int ret = 0;
        int hand = 0;
        int[] parRet = new int[1];
        byte[] cutPage = new byte[]{29, 86, 1};
        byte[] testData = ("Test XPrinterJIO_" + portName + ". \r\n").getBytes();
        PrinterStatus printerStatus = new PrinterStatus();
        hand = IOPort.nativeOpenPortEx(portName, portSetting, timeOut);
        ret += IOPort.nativeGetParsedStatusEx(hand, printerStatus);
        byte[] recData = null;
        String resString = "";
        for (int i = 0; i < printerStatus.rawLength; ++i) {
            resString = resString + String.format("%02X  ", printerStatus.raw[i]);
        }
        resString = resString + "\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n";
        recData = resString.getBytes();
        ret += IOPort.nativeWritePortEx(hand, testData, 0, testData.length, parRet);
        ret += IOPort.nativeWritePortEx(hand, recData, 0, recData.length, parRet);
        ret += IOPort.nativeWritePortEx(hand, cutPage, 0, cutPage.length, parRet);
        return ret += IOPort.nativeClosePort(hand);
    }

    static {
        String jIo = "JposPrinterJIO";
        String j32 = "x32.dll";
        String j64 = "x64.dll";
        String osName = IOPort.getOsName();
        String runTimeArch = IOPort.getJavaArch();
        jIo = runTimeArch.equals("64") ? jIo + j64 : jIo + j32;
        try {
            File dirFile = new File(".");
            String curPath = dirFile.getCanonicalPath() + "\\" + jIo;
            Runtime.getRuntime().load(curPath);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                }
            });
            s_classServicesReadied = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        s_ports = new Vector();
    }
}

