/*
 * Decompiled with CFR 0.152.
 */
package net.jposprinter.javaposdrv;

import java.util.HashMap;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.loader.JposServiceInstance;
import jpos.loader.JposServiceInstanceFactory;
import net.jposprinter.javaposdrv.POSPrinterThermal;

public class ServiceInstanceFactory
implements JposServiceInstanceFactory {
    private HashMap m_printerClaimLocks = new HashMap();
    private HashMap m_cashDrawerClaimLocks = new HashMap();
    private HashMap m_MICRClaimLocks = new HashMap();
    private JposEntry m_config;
    private static final int FULLCUT = 1;
    private static final int PARTIALCUT = 2;
    private static final int NEAREND = 4;
    private static final int FONTB = 8;
    private static final int DOTLINEWIDTH = 16;
    private static final int CAP2COLOR = 32;
    private static final int CAP18PIN = 64;
    private static final int COVEROPEN = 128;

    @Override
    public JposServiceInstance createInstance(String paramString, JposEntry paramJposEntry) throws JposException {
        this.m_config = paramJposEntry;
        if (!paramJposEntry.hasPropertyWithName("deviceCategory") || paramJposEntry.getPropertyType("deviceCategory") != String.class) {
            throw new JposException(104, "A required configuration property (\"category\" of type String) is missing.");
        }
        String str1 = (String)paramJposEntry.getPropertyValue("deviceCategory");
        if (str1.equals("POSPrinter")) {
            if (!paramJposEntry.hasPropertyWithName("model") || paramJposEntry.getPropertyType("model") != String.class) {
                throw new JposException(104, "A required configuration property (\"model\" of type String) is missing.");
            }
            String str3 = (String)paramJposEntry.getPropertyValue("model");
            boolean[] arrayOfBoolean = (boolean[])this.m_printerClaimLocks.get(paramString);
            if (null == arrayOfBoolean) {
                arrayOfBoolean = new boolean[1];
                this.m_printerClaimLocks.put(paramString, arrayOfBoolean);
            }
            if (paramJposEntry.hasPropertyWithName("DBCS") && String.class == paramJposEntry.getPropertyType("DBCS")) {
                if (!(((String)paramJposEntry.getPropertyValue("DBCS")).equals("SJIS") || ((String)paramJposEntry.getPropertyValue("DBCS")).equals("EUC_KR") || ((String)paramJposEntry.getPropertyValue("DBCS")).equals("GB2312") || ((String)paramJposEntry.getPropertyValue("DBCS")).equals("GB18030") || ((String)paramJposEntry.getPropertyValue("DBCS")).equals("Big5") || ((String)paramJposEntry.getPropertyValue("DBCS")).equals(""))) {
                    throw new JposException(104, "A required configuration property (\"DBCS\" of type String) is invalid.");
                }
            } else {
                paramJposEntry.addProperty("DBCS", String.valueOf(""));
            }
            if (this.validateThermalPrinterModel(str3)) {
                return new POSPrinterThermal(this.m_config, arrayOfBoolean);
            }
            throw new JposException(104, "The specified model is unsupported.");
        }
        throw new JposException(104, "The specified device category is not supported.");
    }

    private boolean validateThermalPrinterModel(String paramString) {
        if (paramString.equals("POS80")) {
            this.removeProperty(29);
            this.m_config.addProperty("fullCut", Boolean.FALSE);
            this.m_config.addProperty("nearEndSensor", Boolean.TRUE);
            this.m_config.addProperty("fontB", Boolean.TRUE);
            if (this.m_config.hasPropertyWithName("partialCut")) {
                if (this.m_config.getPropertyType("partialCut") == Boolean.class) {
                    // empty if block
                }
            } else {
                this.m_config.addProperty("partialCut", Boolean.TRUE);
            }
            if (this.m_config.hasPropertyWithName("printableArea")) {
                if (this.m_config.getPropertyType("printableArea") == Double.class) {
                    if (72.0 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", Integer.valueOf("576"));
                    } else if (50.8 == (Double)this.m_config.getPropertyValue("printableArea")) {
                        this.m_config.addProperty("dotLineWidth", Integer.valueOf("406"));
                    }
                }
            } else {
                this.m_config.addProperty("dotLineWidth", Integer.valueOf("576"));
            }
        } else {
            return false;
        }
        if (this.m_config.hasPropertyWithName("printerCategory")) {
            this.m_config.removeProperty("printerCategory");
        }
        this.m_config.addProperty("printerCategory", String.valueOf("ThermalPrinter"));
        return true;
    }

    private void removeProperty(int paramInt) {
        if (1 == (paramInt & 1)) {
            if (this.m_config.hasPropertyWithName("fullCut")) {
                this.m_config.removeProperty("fullCut");
            }
        } else if (2 == (paramInt & 2)) {
            if (this.m_config.hasPropertyWithName("partialCut")) {
                this.m_config.removeProperty("partialCut");
            }
        } else if (4 == (paramInt & 4)) {
            if (this.m_config.hasPropertyWithName("nearEndSensor")) {
                this.m_config.removeProperty("nearEndSensor");
            }
        } else if (8 == (paramInt & 8)) {
            if (this.m_config.hasPropertyWithName("fontB")) {
                this.m_config.removeProperty("fontB");
            }
        } else if (16 == (paramInt & 0x10)) {
            if (this.m_config.hasPropertyWithName("dotLineWidth")) {
                this.m_config.removeProperty("dotLineWidth");
            }
        } else if (32 == (paramInt & 0x20)) {
            if (this.m_config.hasPropertyWithName("cap2Color")) {
                this.m_config.removeProperty("cap2Color");
            }
        } else if (64 == (paramInt & 0x40)) {
            if (this.m_config.hasPropertyWithName("cap18Pin")) {
                this.m_config.removeProperty("cap18Pin");
            }
        } else if (128 == (paramInt & 0x80) && this.m_config.hasPropertyWithName("coverOpen")) {
            this.m_config.removeProperty("coverOpen");
        }
    }
}

