/*
 * Decompiled with CFR 0.152.
 */
package net.jposprinter.javaposdrv;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.loader.JposServiceInstance;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import net.jposprinter.printerio.IOPort;
import net.jposprinter.printerio.IOPortException;
import net.jposprinter.printerio.PrinterStatus;
import net.jposprinter.tools.AsyncOutputDataStruct;
import net.jposprinter.tools.CommandESC;
import net.jposprinter.tools.PrinterFont;

public class POSPrinterBase
implements BaseService,
JposServiceInstance,
ActionListener {
    private boolean[] m_claimLock = new boolean[1];
    private boolean m_deviceEnabled;
    private boolean m_freezeEvents;
    protected int[] m_serviceState = new int[]{1};
    private int[] m_powerState = new int[]{2000};
    private int[] m_powerNotifyEnabled = new int[]{0};
    protected boolean m_flagWhenIdle;
    protected int m_outputId = 0;
    protected int m_errorLevel = 1;
    protected int m_errorStation = 2;
    protected String m_errorString = "";
    protected String m_checkHealthText = "";
    protected boolean m_clearOutputPending = false;
    private boolean m_eventThreadLife = true;
    private boolean m_outputThreadLife = true;
    private boolean m_statusThreadLife = true;
    protected boolean m_processingAsyncOutput = false;
    protected Vector m_eventQueue = new Vector();
    protected List m_asyncOutputQueue = new ArrayList();
    protected Object m_asyncOutputLock = new Object();
    protected Object m_eventLock = new Object();
    private Object m_statusLock = new Object();
    private Thread m_eventThread;
    private Thread m_outputThread;
    private Thread m_statusThread;
    protected PrinterStatus[] m_cachedStatus = new PrinterStatus[]{new PrinterStatus()};
    private String m_commandEmulatorConfig;
    private IOPort m_port;
    private String m_portName;
    private String m_portSettings;
    private int m_ioTimeoutMillis = 5000;
    private int m_ioProgressTimeout = 10000;
    private int m_etbTimeoutMillis = 10000;
    private boolean m_autoReset = false;
    private EventCallbacks m_eventCallbacks;
    protected JRadioButton radio1;
    protected JRadioButton radio2;
    protected JRadioButton radio3;
    protected JTextField textPortName;
    protected JTextField textMode;
    protected JButton button;
    protected JTextField textField;
    private String m_modelName = "";
    private int m_printerCategory;
    protected String m_physicalDeviceDescription = "";
    protected CommandESC m_recPrintMethods = null;
    protected PrinterFont m_recPrinterFont = null;
    protected PrinterFont m_slpPrinterFont = null;
    private boolean m_lastOutputResult = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public POSPrinterBase(JposEntry var1, boolean[] var2) throws JposException {
        String var3 = "";
        String var4 = "";
        this.m_modelName = (String)var1.getPropertyValue("model");
        this.m_printerCategory = !((String)var1.getPropertyValue("printerCategory")).equals("ThermalPrinter") && !((String)var1.getPropertyValue("printerCategory")).equals("DotPrinter") ? 6 : 2;
        if (!var1.hasPropertyWithName("portName") || String.class != var1.getPropertyType("portName")) throw new JposException(104, "A required configuration property (\"portName\" of type String) is missing.");
        this.m_portName = (String)var1.getPropertyValue("portName");
        if (!var1.hasPropertyWithName("portSettings") || String.class != var1.getPropertyType("portSettings")) throw new JposException(104, "A required configuration property (\"portSettings\" of type String) is missing.");
        this.m_portSettings = (String)var1.getPropertyValue("portSettings");
        if (var1.hasPropertyWithName("ioTimeoutMillis") && Integer.class == var1.getPropertyType("ioTimeoutMillis")) {
            this.m_ioTimeoutMillis = (Integer)var1.getPropertyValue("ioTimeoutMillis");
        }
        if (var1.hasPropertyWithName("ioProgressTimeout") && Integer.class == var1.getPropertyType("ioProgressTimeout")) {
            this.m_ioProgressTimeout = (Integer)var1.getPropertyValue("ioProgressTimeout");
        }
        if (var1.hasPropertyWithName("etbTimeoutMillis") && Integer.class == var1.getPropertyType("etbTimeoutMillis")) {
            this.m_etbTimeoutMillis = (Integer)var1.getPropertyValue("etbTimeoutMillis");
        }
        this.m_claimLock = var2;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void deleteInstance() throws JposException {
        try {
            this.close();
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckHealthText() throws JposException {
        return this.m_checkHealthText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getClaimed() throws JposException {
        boolean[] var1 = this.m_claimLock;
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_claimLock[0];
        }
    }

    @Override
    public boolean getDeviceEnabled() throws JposException {
        return this.m_deviceEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setDeviceEnabled(boolean var1) throws JposException {
        this.verifyClaimedState();
        if (this.getState() != 2) {
            throw new JposException(106, "This request failed because the device is busy.");
        }
        if (var1 != this.m_deviceEnabled) {
            if (var1) {
                try {
                    this.m_port = IOPort.getPort(this.m_portName, this.m_portSettings, this.m_ioTimeoutMillis);
                    this.m_cachedStatus[0] = this.m_port.retreiveStatus();
                }
                catch (IOPortException var48) {
                    throw new JposException(107, "The device communications channel could not be opened, check the device and retry.");
                }
                if (null != this.m_eventThread) {
                    return;
                }
                this.m_eventThreadLife = true;
                this.m_eventThread = new Thread(new EventServer());
                this.m_eventThread.start();
                if (null != this.m_statusThread) {
                    return;
                }
                this.m_statusThreadLife = true;
                this.m_statusThread = new Thread(new StatusServer());
                this.m_statusThread.start();
                if (null != this.m_outputThread) {
                    return;
                }
                this.m_outputThreadLife = true;
                this.m_outputThread = new Thread(new OutputServer());
                this.m_outputThread.start();
                this.m_deviceEnabled = true;
            } else {
                Object var2 = this.m_asyncOutputLock;
                Object object = this.m_asyncOutputLock;
                synchronized (object) {
                    this.m_outputThreadLife = false;
                    this.m_asyncOutputLock.notifyAll();
                }
                try {
                    this.m_outputThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.m_outputThread = null;
                }
                var2 = this.m_statusLock;
                object = this.m_statusLock;
                synchronized (object) {
                    this.m_statusThreadLife = false;
                    this.m_statusLock.notifyAll();
                }
                try {
                    this.m_statusThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.m_statusThread = null;
                }
                var2 = this.m_eventLock;
                object = this.m_eventLock;
                synchronized (object) {
                    this.m_eventThreadLife = false;
                    this.m_eventLock.notifyAll();
                }
                try {
                    this.m_eventThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.m_eventThread = null;
                }
                IOPort.releasePort(this.m_port);
                this.m_port = null;
                this.m_deviceEnabled = false;
            }
        }
    }

    @Override
    public String getDeviceServiceDescription() throws JposException {
        return "JposPrinter JavaPOS POSPrinter Service Driver";
    }

    @Override
    public int getDeviceServiceVersion() throws JposException {
        return 1013008;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getFreezeEvents() throws JposException {
        Object var1 = this.m_eventLock;
        Object object = this.m_eventLock;
        synchronized (object) {
            return this.m_freezeEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFreezeEvents(boolean var1) throws JposException {
        Object var2 = this.m_eventLock;
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_freezeEvents = var1;
            this.m_eventLock.notifyAll();
        }
    }

    @Override
    public String getPhysicalDeviceDescription() throws JposException {
        return this.m_physicalDeviceDescription;
    }

    @Override
    public String getPhysicalDeviceName() throws JposException {
        return "JposPrinter " + this.m_modelName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() throws JposException {
        int[] var1 = this.m_serviceState;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_serviceState[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void open(String var1, EventCallbacks var2) throws JposException {
        this.m_eventCallbacks = var2;
        try {
            if (null == this.m_commandEmulatorConfig) {
                // empty if block
            }
        }
        catch (Exception var4) {
            throw new JposException(104, "Failed to create the specified CommandEmulator", var4);
        }
        this.setServiceState(2);
    }

    @Override
    public synchronized void close() throws JposException {
        int var1 = this.getState();
        if (1 != var1) {
            if (2 != var1) {
                throw new JposException(113, "This request is illegal because the service is busy processing asynchronous output.");
            }
            try {
                this.setDeviceEnabled(false);
            }
            catch (JposException jposException) {
                // empty catch block
            }
            try {
                this.release();
            }
            catch (JposException jposException) {
                // empty catch block
            }
            if (null != this.m_port) {
                IOPort.releasePort(this.m_port);
                this.m_port = null;
            }
            this.setServiceState(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void claim(int var1) throws JposException {
        if (-1 > var1) {
            throw new JposException(106, "The claim operation was aborted because an invalid timeout parameter was specified.");
        }
        boolean[] var2 = this.m_claimLock;
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            while (this.m_claimLock[0] && var1 > 0) {
                try {
                    long var3 = System.currentTimeMillis();
                    this.m_claimLock.wait(var1);
                    long var5 = System.currentTimeMillis() - var3;
                    if (var5 > (long)var1) {
                        var1 = 0;
                        continue;
                    }
                    var1 = (int)((long)var1 - var5);
                }
                catch (InterruptedException var8) {
                    throw new JposException(106, "The claim operation was aborted because of thread interruption.");
                }
            }
            if (this.m_claimLock[0]) throw new JposException(112, "The claim operation timed out");
            this.m_claimLock[0] = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void release() throws JposException {
        boolean[] var1 = this.m_claimLock;
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            if (!this.m_claimLock[0]) {
                throw new JposException(106, "This request is illegal because the service is not already claimed.");
            }
            this.setDeviceEnabled(false);
            this.m_claimLock[0] = false;
            this.m_claimLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void checkHealth(int var1) throws JposException {
        new ArrayList();
        if (1 == var1) {
            throw new JposException(106, "This request failed because the specified checkHealth level is unsupported.");
        }
        if (2 == var1) {
            this.verifyDeviceEnabledState();
            this.m_checkHealthText = "Doing checkHealth...\n";
            try {
                List var2 = new ArrayList();
                if (4 == (this.m_printerCategory & 4)) {
                    this.m_checkHealthText = this.m_checkHealthText + "  checking receipt station...\n";
                    this.m_checkHealthText = this.m_checkHealthText + "    success!\n";
                    this.m_checkHealthText = this.m_checkHealthText + "  checking slip station...\n";
                    this.m_checkHealthText = this.m_checkHealthText + "    success!\n";
                }
                this.m_checkHealthText = this.m_checkHealthText + "  checking receipt station...\n";
                var2 = this.m_recPrintMethods.parseEscapeSequences(0, this.getCheckHealthData(), false);
                this.outputData(var2);
                this.m_checkHealthText = this.m_checkHealthText + "    success!\n";
            }
            catch (JposException var13) {
                this.m_checkHealthText = this.m_checkHealthText + "    failure - " + var13.getMessage() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "aborted!\n";
                throw var13;
            }
        } else {
            if (3 != var1) {
                throw new JposException(106, "This request failed because the specified command parameter is unsupported.");
            }
            JFrame var3 = new JFrame("JavaPOS POSPrinter");
            var3.setState(1);
            var3.setExtendedState(1);
            var3.setBounds(0, 0, 0, 0);
            var3.setResizable(false);
            var3.setUndecorated(true);
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception var12) {
                var12.printStackTrace();
            }
            JDialog var4 = new JDialog(var3, "JavaPOS POSPrinter", true);
            var4.setSize(350, 210);
            var4.setResizable(false);
            Rectangle var5 = var4.getGraphicsConfiguration().getBounds();
            var4.setLocation(var5.x + var5.width / 2 - var4.getSize().width / 2, var5.y + var5.height / 2 - var4.getSize().height / 2);
            Container var6 = var4.getContentPane();
            this.radio1 = new JRadioButton("Journal");
            this.radio2 = new JRadioButton("Receipt");
            this.radio3 = new JRadioButton("Slip");
            this.textPortName = new JTextField("PortName : " + this.m_portName);
            this.textMode = new JTextField("ModeName : " + this.m_modelName);
            ButtonGroup var7 = new ButtonGroup();
            var7.add(this.radio2);
            JPanel var8 = new JPanel();
            var8.setLayout(new BoxLayout(var8, 3));
            var8.add(this.textMode);
            var8.add(this.textPortName);
            var8.add(this.radio2);
            var8.setBorder(BorderFactory.createTitledBorder("Station"));
            var8.setPreferredSize(new Dimension(325, 100));
            JPanel var9 = new JPanel();
            var9.setPreferredSize(new Dimension(325, 105));
            var9.add((Component)var8, "First");
            var6.add((Component)var9, "First");
            JPanel var10 = new JPanel();
            this.button = new JButton("CheckHealth");
            this.button.setPreferredSize(new Dimension(323, 28));
            this.button.addActionListener(this);
            var10.add(this.button);
            var4.getRootPane().setDefaultButton(this.button);
            var6.add((Component)var10, "Center");
            JPanel var11 = new JPanel();
            this.textField = new JTextField("");
            this.textField.setPreferredSize(new Dimension(323, 26));
            this.textField.setEditable(false);
            var11.add(this.textField);
            var6.add((Component)var11, "Last");
            this.radio2.setEnabled(true);
            this.textPortName.setEnabled(false);
            this.textMode.setEnabled(false);
            this.radio2.setSelected(true);
            var4.setDefaultCloseOperation(2);
            var3.setDefaultCloseOperation(2);
            var3.pack();
            var3.setVisible(false);
            var4.setVisible(true);
            var3.dispose();
        }
    }

    @Override
    public void directIO(int var1, int[] var2, Object var3) throws JposException {
        throw new JposException(106, "This request failed because the specified command parameter is unsupported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerNotify() throws JposException {
        int[] var1 = this.m_powerNotifyEnabled;
        int[] nArray = this.m_powerNotifyEnabled;
        synchronized (this.m_powerNotifyEnabled) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_powerNotifyEnabled[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerNotify(int var1) throws JposException {
        if (this.m_deviceEnabled) {
            throw new JposException(105, "This request is illegal because the service is enabled. ");
        }
        if (var1 != 0 && var1 != 1) {
            throw new JposException(106, "This request is illegal because the powerNotify parameter is unsupported.");
        }
        int[] var2 = this.m_powerNotifyEnabled;
        int[] nArray = this.m_powerNotifyEnabled;
        synchronized (this.m_powerNotifyEnabled) {
            this.m_powerNotifyEnabled[0] = var1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPowerState() throws JposException {
        int[] var1 = this.m_powerState;
        int[] nArray = this.m_powerState;
        synchronized (this.m_powerState) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_powerState[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPowerState(int var1) {
        int[] var2 = this.m_powerState;
        int[] nArray = this.m_powerState;
        synchronized (this.m_powerState) {
            this.m_powerState[0] = var1;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputData(List var1) throws JposException {
        IOPort var2 = this.m_port;
        IOPort iOPort = this.m_port;
        synchronized (iOPort) {
            PrinterStatus var3;
            try {
                var3 = this.m_port.retreiveStatus();
            }
            catch (IOPortException var14) {
                if (1 == this.getPowerNotify() && 2002 != this.getPowerState()) {
                    this.setPowerState(2002);
                    this.addEvent(new StatusUpdateEvent(this, 2002));
                }
                throw new JposException(107, "This print operation failed because device communication failed.");
            }
            if (1 == this.getPowerNotify()) {
                if (var3.offline) {
                    if (2003 != this.getPowerState()) {
                        this.setPowerState(2003);
                        this.addEvent(new StatusUpdateEvent(this, 2003));
                    }
                } else if (2002 == this.getPowerState()) {
                    this.setPowerState(2003);
                    this.addEvent(new StatusUpdateEvent(this, 2003));
                }
            }
            this.updateStatus(var3);
            if (1 == this.getPowerNotify() && !var3.offline && 2001 != this.getPowerState()) {
                this.setPowerState(2001);
                this.addEvent(new StatusUpdateEvent(this, 2001));
            }
            if (var3.offline) {
                throw new JposException(108, "This print operation failed because the device is offline.");
            }
            try {
                byte[] var8;
                int var7;
                int var4 = 0;
                Object var5 = null;
                int var6 = 0;
                for (var7 = 0; var7 < var1.size(); ++var7) {
                    var8 = (byte[])var1.get(var7);
                    var4 += var8.length;
                }
                byte[] var19 = new byte[var4];
                for (var7 = 0; var7 < var1.size(); ++var7) {
                    var8 = (byte[])var1.get(var7);
                    System.arraycopy(var8, 0, var19, var6, var8.length);
                    var6 += var8.length;
                }
                if (null != var19) {
                    int var9;
                    int var10;
                    long var23 = System.currentTimeMillis();
                    for (var9 = 0; System.currentTimeMillis() - var23 < (long)this.m_ioProgressTimeout && var9 < var19.length; var9 += var10) {
                        var10 = this.m_port.writePort(var19, var9, var19.length - var9);
                        if (0 == var10) continue;
                        var23 = System.currentTimeMillis();
                    }
                    if (var9 < var19.length) {
                        this.updateStatus();
                        throw new JposException(112);
                    }
                }
            }
            catch (IOPortException var16) {
                this.updateStatus();
                throw new JposException(112);
            }
            this.m_lastOutputResult = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus() throws JposException {
        IOPort var1 = this.m_port;
        IOPort iOPort = this.m_port;
        synchronized (iOPort) {
            PrinterStatus var2;
            try {
                var2 = this.m_port.retreiveStatus();
            }
            catch (IOPortException var11) {
                if (1 == this.getPowerNotify() && 2002 != this.getPowerState()) {
                    this.setPowerState(2002);
                    this.addEvent(new StatusUpdateEvent(this, 2002));
                }
                throw new JposException(107, "This print operation failed because device communication failed.");
            }
            if (1 == this.getPowerNotify()) {
                if (var2.offline) {
                    if (2003 != this.getPowerState()) {
                        this.setPowerState(2003);
                        this.addEvent(new StatusUpdateEvent(this, 2003));
                    }
                } else if (2002 == this.getPowerState()) {
                    this.setPowerState(2003);
                    this.addEvent(new StatusUpdateEvent(this, 2003));
                }
            }
            try {
                this.updateStatus(var2);
            }
            finally {
                if (this.getPowerNotify() == 1 && !var2.offline && 2001 != this.getPowerState()) {
                    this.setPowerState(2001);
                    this.addEvent(new StatusUpdateEvent(this, 2001));
                }
                if (!(var2.offline || var2.coverOpen || var2.receiptPaperNearEmptyInner || var2.receiptPaperEmpty || var2.receiveBufferOverflow || 4 != this.getState())) {
                    this.setErrorLevel(1, 2, "");
                    this.setServiceState(2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(PrinterStatus var1) throws JposException {
        PrinterStatus[] var2 = this.m_cachedStatus;
        PrinterStatus[] printerStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            if (this.getPowerNotify() == 1) {
                if (var1.offline) {
                    if (this.getPowerState() != 2003) {
                        this.setPowerState(2003);
                        this.addEvent(new StatusUpdateEvent(this, 2003));
                    }
                } else if (this.getPowerState() != 2001) {
                    this.setPowerState(2001);
                    this.addEvent(new StatusUpdateEvent(this, 2001));
                }
            }
            PrinterStatus var3 = this.m_cachedStatus[0];
            this.m_cachedStatus[0] = var1;
            if (var1.coverOpen) {
                if (!var3.coverOpen) {
                    this.addEvent(new StatusUpdateEvent(this, 11));
                }
            } else if (var3.coverOpen) {
                this.addEvent(new StatusUpdateEvent(this, 12));
            }
            if (var1.receiptPaperEmpty) {
                if (!var3.receiptPaperEmpty) {
                    this.addEvent(new StatusUpdateEvent(this, 24));
                }
            } else if (var1.receiptPaperNearEmptyInner) {
                if (var3.receiptPaperEmpty || !var3.receiptPaperNearEmptyInner) {
                    this.addEvent(new StatusUpdateEvent(this, 25));
                }
            } else if (var3.receiptPaperEmpty || var3.receiptPaperNearEmptyInner) {
                this.addEvent(new StatusUpdateEvent(this, 26));
            }
            if (var1.coverOpen) {
                throw new JposException(114, 201, "This print request failed because the device's cover is open.");
            }
            if (var1.receiptPaperEmpty) {
                throw new JposException(114, 203, "This print request failed because the device is out of paper.");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyClaimedState() throws JposException {
        boolean[] var1 = this.m_claimLock;
        boolean[] blArray = this.m_claimLock;
        synchronized (this.m_claimLock) {
            if (!this.m_claimLock[0]) {
                throw new JposException(103, "The service is not claimed.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void verifyDeviceEnabledState() throws JposException {
        this.verifyClaimedState();
        if (!this.m_deviceEnabled) {
            throw new JposException(105, "The service is not enabled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServiceState(int var1) {
        int[] var2 = this.m_serviceState;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            if (this.m_serviceState[0] != var1) {
                this.m_serviceState[0] = var1;
                if (this.m_serviceState[0] != 4) {
                    this.m_errorString = "";
                }
                if (this.m_serviceState[0] == 2 && this.m_flagWhenIdle) {
                    this.m_flagWhenIdle = false;
                    this.addEvent(new StatusUpdateEvent(this, 1001));
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAsyncOutput(List var1) throws JposException {
        Object var2 = this.m_asyncOutputLock;
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            if (9999 < this.m_outputId) {
                this.m_outputId = 0;
            }
            ++this.m_outputId;
            this.m_asyncOutputQueue.add(new AsyncOutputDataStruct(var1, this.m_outputId));
            this.setServiceState(3);
            this.m_asyncOutputLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AsyncOutputDataStruct retreiveAsyncOutputOrDie() {
        Object var1 = this.m_asyncOutputLock;
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            while ((this.m_asyncOutputQueue.isEmpty() || this.m_clearOutputPending) && this.m_outputThreadLife) {
                try {
                    this.m_asyncOutputLock.wait();
                }
                catch (InterruptedException var4) {
                    return null;
                }
            }
            if (!this.m_outputThreadLife) {
                return null;
            }
            this.m_processingAsyncOutput = true;
            return (AsyncOutputDataStruct)this.m_asyncOutputQueue.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firstAsyncOutputProcessed(boolean var1) {
        Object var2 = this.m_asyncOutputLock;
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            this.m_processingAsyncOutput = false;
            AsyncOutputDataStruct var3 = (AsyncOutputDataStruct)this.m_asyncOutputQueue.remove(0);
            if (var1) {
                this.addEvent(new OutputCompleteEvent(this, var3.getOutputID()));
            }
            if (this.m_asyncOutputQueue.isEmpty()) {
                this.setServiceState(2);
            } else {
                this.setServiceState(3);
            }
            this.m_asyncOutputLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(JposEvent var1) {
        Object var2 = this.m_eventLock;
        Object object = this.m_eventLock;
        synchronized (object) {
            this.m_eventQueue.add(var1);
            this.m_eventLock.notifyAll();
        }
    }

    protected String getCheckHealthData() {
        StringBuffer var3 = new StringBuffer();
        var3.append("\u001b|N");
        var3.append("\u001b|bC" + this.m_modelName + " - CheckHealth" + '\n');
        var3.append("\u001b|bC-------------------------------\n");
        var3.append("\u001b|NPort name : \u001b|uC" + this.m_portName + "\n");
        var3.append('\n');
        var3.append("\u001b|N\u001b|bCbold\n");
        var3.append("\u001b|N\u001b|uCunderline\n");
        var3.append("\u001b|N\u001b|rvCreverse\n");
        var3.append("\u001b|N\u001b|2C2x wide\n");
        var3.append("\u001b|N\u001b|3C2x high\n");
        var3.append("\u001b|N\u001b|4C2x wide 2x high\n");
        var3.append("\u001b|N\u001b|cAcenter alignment\n");
        var3.append("\u001b|N\u001b|rAright aligment\n");
        var3.append("\u001b|Nnormal\n");
        var3.append("\u001b|N\u001b|cAJposPrinter(C)2016-Lee\n");
        var3.append("\u001b|N\u001b|50fP");
        return var3.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setErrorLevel(int var1, int var2, String var3) {
        int[] var4 = this.m_serviceState;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            if (1 != var1) {
                this.setServiceState(4);
            }
            this.m_errorLevel = var1;
            this.m_errorStation = var2;
            this.m_errorString = var3;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent var1) {
        if (var1.getSource().equals(this.button)) {
            try {
                this.verifyDeviceEnabledState();
                if (this.radio2.isSelected()) {
                    this.m_checkHealthText = this.m_checkHealthText + "  checking receipt station...\n";
                    List var2 = this.m_recPrintMethods.parseEscapeSequences(0, this.getCheckHealthData(), false);
                    this.outputData(var2);
                }
            }
            catch (JposException var3) {
                this.m_checkHealthText = this.m_checkHealthText + "    failure - " + var3.getMessage() + "\n";
                this.m_checkHealthText = this.m_checkHealthText + "aborted!\n";
                switch (var3.getErrorCode()) {
                    case 0: {
                        this.textField.setText("JPOS_SUCCESS");
                        break;
                    }
                    case 101: {
                        this.textField.setText("JPOS_E_CLOSED");
                        break;
                    }
                    case 102: {
                        this.textField.setText("JPOS_E_CLAIMED");
                        break;
                    }
                    case 103: {
                        this.textField.setText("JPOS_E_NOTCLAIMED");
                        break;
                    }
                    case 104: {
                        this.textField.setText("JPOS_E_NOSERVICE");
                        break;
                    }
                    case 105: {
                        this.textField.setText("JPOS_E_DISABLED");
                        break;
                    }
                    case 106: {
                        this.textField.setText("JPOS_E_ILLEGAL");
                        break;
                    }
                    case 107: {
                        this.textField.setText("JPOS_E_NOHARDWARE");
                        break;
                    }
                    case 108: {
                        this.textField.setText("JPOS_E_OFFLINE");
                        break;
                    }
                    case 109: {
                        this.textField.setText("JPOS_E_NOEXIST");
                        break;
                    }
                    case 110: {
                        this.textField.setText("JPOS_E_EXISTS");
                        break;
                    }
                    case 111: {
                        this.textField.setText("JPOS_E_FAILURE");
                        break;
                    }
                    case 112: {
                        this.textField.setText("JPOS_E_TIMEOUT");
                        break;
                    }
                    case 113: {
                        this.textField.setText("JPOS_E_BUSY");
                        break;
                    }
                    case 114: {
                        switch (var3.getErrorCodeExtended()) {
                            case 201: {
                                this.textField.setText("JPOS_E_EXTENDED(JPOS_EPTR_COVER_OPEN)");
                                return;
                            }
                            case 202: {
                                this.textField.setText("JPOS_E_EXTENDED(JPOS_EPTR_JRN_EMPTY)");
                                return;
                            }
                            case 203: {
                                this.textField.setText("JPOS_E_EXTENDED(JPOS_EPTR_REC_EMPTY)");
                                return;
                            }
                            case 204: {
                                this.textField.setText("JPOS_E_EXTENDED(JPOS_EPTR_SLP_EMPTY)");
                                return;
                            }
                        }
                        this.textField.setText("ResultCode Error !?");
                        return;
                    }
                    default: {
                        this.textField.setText("ResultCode Error !?");
                    }
                }
                return;
            }
            this.m_checkHealthText = this.m_checkHealthText + "    success!\n";
            this.textField.setText("JPOS_SUCCESS");
        }
    }

    protected class OutputServer
    implements Runnable {
        protected OutputServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                AsyncOutputDataStruct var1 = null;
                Object var2 = POSPrinterBase.this.m_asyncOutputLock;
                Object object = POSPrinterBase.this.m_asyncOutputLock;
                synchronized (object) {
                    while ((POSPrinterBase.this.m_asyncOutputQueue.isEmpty() || POSPrinterBase.this.m_clearOutputPending) && POSPrinterBase.this.m_outputThreadLife) {
                        try {
                            if (POSPrinterBase.this.m_asyncOutputQueue.isEmpty()) {
                                POSPrinterBase.this.m_asyncOutputLock.wait();
                                continue;
                            }
                            POSPrinterBase.this.m_clearOutputPending = false;
                        }
                        catch (InterruptedException var6) {
                            return;
                        }
                    }
                    if (!POSPrinterBase.this.m_outputThreadLife && POSPrinterBase.this.m_lastOutputResult) {
                        return;
                    }
                    POSPrinterBase.this.m_processingAsyncOutput = true;
                    var1 = (AsyncOutputDataStruct)POSPrinterBase.this.m_asyncOutputQueue.get(0);
                    POSPrinterBase.this.m_asyncOutputLock.notifyAll();
                }
                try {
                    POSPrinterBase.this.outputData(var1.getAsyncOutputByteList());
                    POSPrinterBase.this.firstAsyncOutputProcessed(true);
                    continue;
                }
                catch (JposException var5) {
                    POSPrinterBase.this.m_lastOutputResult = false;
                    POSPrinterBase.this.setErrorLevel(2, 2, var5.getMessage());
                    POSPrinterBase pOSPrinterBase = POSPrinterBase.this;
                    pOSPrinterBase.getClass();
                    WaitableErrorEvent var3 = pOSPrinterBase.new WaitableErrorEvent(this, var5.getErrorCode(), var5.getErrorCodeExtended(), 1, 12);
                    POSPrinterBase.this.addEvent(var3);
                    if (12 != var3.getErrorResponse()) continue;
                    POSPrinterBase.this.firstAsyncOutputProcessed(false);
                    POSPrinterBase.this.setErrorLevel(1, 2, "");
                    continue;
                }
                break;
            }
        }
    }

    protected class EventServer
    implements Runnable {
        protected EventServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                JposEvent var1 = null;
                Object var2 = POSPrinterBase.this.m_eventLock;
                Object object = POSPrinterBase.this.m_eventLock;
                synchronized (object) {
                    while ((POSPrinterBase.this.m_freezeEvents || POSPrinterBase.this.m_eventQueue.isEmpty()) && POSPrinterBase.this.m_eventThreadLife) {
                        try {
                            POSPrinterBase.this.m_eventLock.wait();
                        }
                        catch (InterruptedException var5) {
                            return;
                        }
                    }
                    if (!POSPrinterBase.this.m_eventThreadLife) {
                        return;
                    }
                    var1 = (JposEvent)POSPrinterBase.this.m_eventQueue.remove(0);
                }
                if (var1 instanceof StatusUpdateEvent) {
                    POSPrinterBase.this.m_eventCallbacks.fireStatusUpdateEvent((StatusUpdateEvent)var1);
                    continue;
                }
                if (var1 instanceof OutputCompleteEvent) {
                    POSPrinterBase.this.m_eventCallbacks.fireOutputCompleteEvent((OutputCompleteEvent)var1);
                    continue;
                }
                if (var1 instanceof DataEvent) {
                    POSPrinterBase.this.m_eventCallbacks.fireDataEvent((DataEvent)var1);
                    continue;
                }
                if (var1 instanceof ErrorEvent) {
                    POSPrinterBase.this.m_eventCallbacks.fireErrorEvent((ErrorEvent)var1);
                    continue;
                }
                if (!(var1 instanceof DirectIOEvent)) continue;
                POSPrinterBase.this.m_eventCallbacks.fireDirectIOEvent((DirectIOEvent)var1);
            }
        }
    }

    protected class StatusServer
    implements Runnable {
        protected StatusServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = POSPrinterBase.this.m_statusLock;
                synchronized (object) {
                    if (!POSPrinterBase.this.m_statusThreadLife) {
                        return;
                    }
                }
                try {
                    POSPrinterBase.this.updateStatus();
                }
                catch (JposException jposException) {
                    // empty catch block
                }
                object = POSPrinterBase.this.m_statusLock;
                synchronized (object) {
                    try {
                        POSPrinterBase.this.m_statusLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class WaitableErrorEvent
    extends ErrorEvent {
        private boolean errorResponseSet;

        public WaitableErrorEvent(Object var2, int var3, int var4, int var5, int var6) {
            super(var2, var3, var4, var5, var6);
            this.errorResponseSet = false;
        }

        @Override
        public synchronized void setErrorResponse(int var1) {
            if (11 != var1 && 12 != var1) {
                var1 = 12;
            }
            this.errorResponse = var1;
            this.errorResponseSet = true;
            this.notifyAll();
        }

        @Override
        public synchronized int getErrorResponse() {
            while (!this.errorResponseSet) {
                try {
                    this.wait();
                }
                catch (InterruptedException var2) {
                    this.errorResponse = 12;
                    this.errorResponseSet = true;
                }
            }
            return this.errorResponse;
        }
    }
}

