/*
 * Decompiled with CFR 0.152.
 */
package net.jposprinter.tools;

import jpos.JposException;

public class MapModeConversion {
    private int m_mapMode = 1;
    private double m_dotDimensionHeight = 0.125;
    private double m_dotDimensionWidth = 0.125;

    public int getMapMode() {
        return this.m_mapMode;
    }

    public double getDotDimensionHeight() {
        return this.m_dotDimensionHeight;
    }

    public void setDotDimensionHeight(double paramDouble) {
        this.m_dotDimensionHeight = paramDouble;
    }

    public double getDotDimensionWidth() {
        return this.m_dotDimensionWidth;
    }

    public void setDotDimensionWidth(double paramDouble) {
        this.m_dotDimensionWidth = paramDouble;
    }

    public void setMapMode(int paramInt) throws JposException {
        if (1 != paramInt && 3 != paramInt && 4 != paramInt && 2 != paramInt) {
            throw new JposException(106, "This request is illegal because the mapMode parameter is unsupported.");
        }
        this.m_mapMode = paramInt;
    }

    public int mapModeToDot(int paramInt, double paramDouble) {
        if (this.m_mapMode == 2) {
            return (int)((double)paramInt * 0.017638888888888888 / paramDouble);
        }
        if (this.m_mapMode == 3) {
            return (int)((double)paramInt * 0.0254 / paramDouble);
        }
        if (this.m_mapMode == 4) {
            return (int)((double)paramInt / 100.0 / paramDouble);
        }
        return paramInt;
    }

    public int dotToMapMode(int paramInt, double paramDouble) {
        if (this.m_mapMode == 2) {
            return (int)((double)paramInt * paramDouble * 56.69291338582678);
        }
        if (this.m_mapMode == 3) {
            return (int)((double)paramInt * paramDouble * 39.37007874015748);
        }
        if (this.m_mapMode == 4) {
            return (int)((double)paramInt * paramDouble * 100.0);
        }
        return paramInt;
    }

    public int mapModeToDotHeight(int paramInt) {
        if (this.m_mapMode == 2) {
            return (int)((double)paramInt * 0.017638888888888888 / this.m_dotDimensionHeight);
        }
        if (this.m_mapMode == 3) {
            return (int)((double)paramInt * 0.0254 / this.m_dotDimensionHeight);
        }
        if (this.m_mapMode == 4) {
            return (int)((double)paramInt / 100.0 / this.m_dotDimensionHeight);
        }
        return paramInt;
    }

    public int mapModeToDotWidth(int paramInt) {
        if (this.m_mapMode == 2) {
            return (int)((double)paramInt * 0.017638888888888888 / this.m_dotDimensionWidth);
        }
        if (this.m_mapMode == 3) {
            return (int)((double)paramInt * 0.0254 / this.m_dotDimensionWidth);
        }
        if (this.m_mapMode == 4) {
            return (int)((double)paramInt / 100.0 / this.m_dotDimensionWidth);
        }
        return paramInt;
    }
}

