/*
 * Decompiled with CFR 0.152.
 */
package net.jposprinter.tools;

import java.awt.Image;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import jpos.JposException;
import jpos.config.JposEntry;
import net.jposprinter.tools.CommandCreator;
import net.jposprinter.tools.PrinterFont;

public abstract class CommandESC
extends CommandCreator {
    private int m_DBCS = 0;
    protected PrinterFont m_printerFont = null;
    private static final int SJIS = 1;
    private static final int EUC_KR = 2;
    private static final int GB2312 = 3;
    private static final int GB18030 = 4;
    private static final int BIG5 = 5;
    private boolean m_capNvBitImage = false;

    public CommandESC(PrinterFont paramPrinterFont, JposEntry paramJposEntry) {
        this.m_printerFont = paramPrinterFont;
        if (paramJposEntry.hasPropertyWithName("useNVBitImage") && Boolean.class == paramJposEntry.getPropertyType("useNVBitImage")) {
            this.m_capNvBitImage = (Boolean)paramJposEntry.getPropertyValue("useNVBitImage");
        }
        if (((String)paramJposEntry.getPropertyValue("DBCS")).equals("SJIS")) {
            this.m_DBCS = 1;
        } else if (((String)paramJposEntry.getPropertyValue("DBCS")).equals("EUC_KR")) {
            this.m_DBCS = 2;
        } else if (((String)paramJposEntry.getPropertyValue("DBCS")).equals("GB2312")) {
            this.m_DBCS = 3;
        } else if (((String)paramJposEntry.getPropertyValue("DBCS")).equals("GB18030")) {
            this.m_DBCS = 4;
        } else if (((String)paramJposEntry.getPropertyValue("DBCS")).equals("Big5")) {
            this.m_DBCS = 5;
        }
    }

    @Override
    public List headerCommand() {
        ArrayList<byte[]> localArrayList = new ArrayList<byte[]>();
        byte[] arrayOfByte = new byte[]{27, 123, 0};
        if (1 == this.getRotatePrint()) {
            arrayOfByte[2] = 0;
        } else if (259 == this.getRotatePrint()) {
            arrayOfByte[2] = 1;
        }
        localArrayList.add(arrayOfByte);
        try {
            this.multipleHeightSetting(1, false);
            this.multipleWidthSetting(1, false);
        }
        catch (JposException jposException) {
            // empty catch block
        }
        return localArrayList;
    }

    @Override
    protected byte[] boldCommand() {
        return new byte[]{27, 69, 1};
    }

    @Override
    protected byte[] boldCommandReversed() {
        return new byte[]{27, 69, 0};
    }

    @Override
    protected byte[] justifyLeftCommand() {
        return new byte[]{27, 97, 48};
    }

    @Override
    protected byte[] justifyCenterCommand() {
        return new byte[]{27, 97, 49};
    }

    @Override
    protected byte[] justifyRightCommand() {
        return new byte[]{27, 97, 50};
    }

    @Override
    protected byte[] underlineCommand(int paramInt, boolean paramBoolean) throws JposException {
        byte[] arrayOfByte = new byte[]{27, 45, 50};
        if (-1 != paramInt && 2 != paramInt) {
            if (0 == paramInt) {
                arrayOfByte[2] = 0;
            } else if (paramBoolean) {
                throw new JposException(106, "This request is illegal and modify 2-dot thick underline.");
            }
        }
        return arrayOfByte;
    }

    @Override
    protected byte[] feedLinesCommand(int paramInt, boolean paramBoolean) throws JposException {
        byte[] arrayOfByte = new byte[]{27, 74, 1};
        if (0 == paramInt) {
            if (paramBoolean) {
                throw new JposException(106, "This request is illegal and feed 1 line.");
            }
        } else if (127 < paramInt) {
            if (paramBoolean) {
                throw new JposException(106, "This request is illegal and feed 127 lines.");
            }
            arrayOfByte[2] = 127;
        } else {
            arrayOfByte[2] = (byte)paramInt;
        }
        return arrayOfByte;
    }

    @Override
    protected byte[] reverseVideoCommand(boolean paramBoolean) throws JposException {
        return new byte[]{29, 66, 1};
    }

    @Override
    protected byte[] reverseVideoCommandReversed(boolean paramBoolean) throws JposException {
        return new byte[]{29, 66, 0};
    }

    @Override
    public abstract List bitmapCommand(Image var1, int var2, int var3, int var4) throws JposException;

    protected boolean convertColor2Mono(int paramInt) {
        int i = paramInt >> 16 & 0xFF;
        int j = paramInt >> 8 & 0xFF;
        int k = paramInt & 0xFF;
        return i * 30 + j * 59 + k * 11 < 12800;
    }

    @Override
    public byte[] selectReceiptStationCommand() {
        return new byte[]{27, 43, 65, 48};
    }

    @Override
    public byte[] selectSlipStationCommand() {
        return new byte[]{27, 43, 65, 51};
    }

    @Override
    protected byte[] getCharacterCodeBytes(String paramString) {
        try {
            if (0 == this.m_DBCS) {
                switch (this.m_printerFont.getCharacterSet()) {
                    case 928: {
                        return paramString.getBytes("ISO8859_7");
                    }
                    case 932: {
                        return paramString.getBytes("SJIS");
                    }
                    case 998: {
                        return paramString.getBytes("iso-8859-1");
                    }
                    case 999: {
                        return paramString.getBytes("Cp1252");
                    }
                    case 437: 
                    case 737: 
                    case 852: 
                    case 855: 
                    case 857: 
                    case 858: 
                    case 860: 
                    case 861: 
                    case 862: 
                    case 863: 
                    case 864: 
                    case 865: 
                    case 866: 
                    case 869: 
                    case 874: 
                    case 1250: 
                    case 1251: 
                    case 1252: {
                        return paramString.getBytes("Cp" + Integer.toString(this.m_printerFont.getCharacterSet()));
                    }
                }
                return paramString.getBytes("iso-8859-1");
            }
            switch (this.m_DBCS) {
                case 1: {
                    return paramString.getBytes("MS932");
                }
                case 2: {
                    return paramString.getBytes("EUC_KR");
                }
                case 3: {
                    return paramString.getBytes("EUC_CN");
                }
                case 4: {
                    return paramString.getBytes("GB18030");
                }
                case 5: {
                    return paramString.getBytes("Big5");
                }
            }
            return paramString.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return paramString.getBytes();
        }
    }

    @Override
    protected boolean getCapNvBitImage() {
        return this.m_capNvBitImage;
    }
}

