/*
 * Decompiled with CFR 0.152.
 */
package net.jposprinter.javaposdrv;

import java.awt.Image;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.StatusUpdateEvent;
import jpos.services.POSPrinterService113;
import net.jposprinter.javaposdrv.POSPrinterBase;
import net.jposprinter.printerio.PrinterStatus;
import net.jposprinter.tools.BMPImageProcessor;
import net.jposprinter.tools.CommandESCThermal;
import net.jposprinter.tools.MapModeConversion;
import net.jposprinter.tools.PrinterFontESCThermal;

public class POSPrinterThermal
extends POSPrinterBase
implements POSPrinterService113,
ActionListener {
    private List m_transactionOutputQueue = null;
    private boolean m_transaction = false;
    private boolean m_asyncMode = false;
    private boolean m_recLetterQuality = false;
    private double m_recDotDimensionHeight = 0.125;
    private double m_recDotDimensionWidth = 0.125;
    private boolean m_capRecNearEndSensor = false;
    private MapModeConversion m_recMapMode = new MapModeConversion();

    public POSPrinterThermal(JposEntry var1, boolean[] var2) throws JposException {
        super(var1, var2);
        this.m_recMapMode.setDotDimensionHeight(this.m_recDotDimensionHeight);
        this.m_recMapMode.setDotDimensionWidth(this.m_recDotDimensionWidth);
        this.m_capRecNearEndSensor = (Boolean)var1.getPropertyValue("nearEndSensor");
        this.m_recPrinterFont = new PrinterFontESCThermal((Integer)var1.getPropertyValue("dotLineWidth"), (Boolean)var1.getPropertyValue("fontB"));
        this.m_recPrintMethods = new CommandESCThermal(this.m_recPrinterFont, this.m_recMapMode, var1);
        this.m_physicalDeviceDescription = "Star Micronics single station thermal printer";
    }

    @Override
    public int getCapCharacterSet() throws JposException {
        return 998;
    }

    @Override
    public boolean getCapConcurrentJrnRec() throws JposException {
        return false;
    }

    @Override
    public boolean getCapConcurrentJrnSlp() throws JposException {
        return false;
    }

    @Override
    public boolean getCapConcurrentRecSlp() throws JposException {
        return false;
    }

    @Override
    public boolean getCapCoverSensor() throws JposException {
        return true;
    }

    @Override
    public boolean getCapJrn2Color() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnBold() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnDhigh() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnDwide() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnDwideDhigh() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnEmptySensor() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnItalic() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnNearEndSensor() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnPresent() throws JposException {
        return false;
    }

    @Override
    public boolean getCapJrnUnderline() throws JposException {
        return false;
    }

    @Override
    public boolean getCapRec2Color() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecBarCode() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecBitmap() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecBold() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecDhigh() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecDwide() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecDwideDhigh() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecEmptySensor() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecItalic() throws JposException {
        return false;
    }

    @Override
    public boolean getCapRecLeft90() throws JposException {
        return false;
    }

    @Override
    public boolean getCapRecNearEndSensor() throws JposException {
        return this.m_capRecNearEndSensor;
    }

    @Override
    public boolean getCapRecPapercut() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecPresent() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecRight90() throws JposException {
        return false;
    }

    @Override
    public boolean getCapRecRotate180() throws JposException {
        return true;
    }

    @Override
    public boolean getCapRecStamp() throws JposException {
        return false;
    }

    @Override
    public boolean getCapRecUnderline() throws JposException {
        return true;
    }

    @Override
    public boolean getCapSlp2Color() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpBarCode() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpBitmap() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpBold() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpDhigh() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpDwide() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpDwideDhigh() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpEmptySensor() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpFullslip() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpItalic() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpLeft90() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpNearEndSensor() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpPresent() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpRight90() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpRotate180() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpUnderline() throws JposException {
        return false;
    }

    @Override
    public boolean getCapTransaction() throws JposException {
        return true;
    }

    @Override
    public int getCapPowerReporting() throws JposException {
        return 2;
    }

    @Override
    public int getCapJrnCartridgeSensor() throws JposException {
        return 0;
    }

    @Override
    public int getCapJrnColor() throws JposException {
        return 0;
    }

    @Override
    public int getCapRecCartridgeSensor() throws JposException {
        return 0;
    }

    @Override
    public int getCapRecColor() throws JposException {
        return 3;
    }

    @Override
    public int getCapRecMarkFeed() throws JposException {
        return 0;
    }

    @Override
    public boolean getCapSlpBothSidesPrint() throws JposException {
        return false;
    }

    @Override
    public int getCapSlpCartridgeSensor() throws JposException {
        return 0;
    }

    @Override
    public int getCapSlpColor() throws JposException {
        return 0;
    }

    @Override
    public boolean getCapMapCharacterSet() throws JposException {
        return false;
    }

    @Override
    public boolean getCapStatisticsReporting() throws JposException {
        return false;
    }

    @Override
    public boolean getCapUpdateStatistics() throws JposException {
        return false;
    }

    @Override
    public boolean getCapCompareFirmwareVersion() throws JposException {
        return false;
    }

    @Override
    public boolean getCapConcurrentPageMode() throws JposException {
        return false;
    }

    @Override
    public boolean getCapRecPageMode() throws JposException {
        return false;
    }

    @Override
    public boolean getCapSlpPageMode() throws JposException {
        return false;
    }

    @Override
    public boolean getCapUpdateFirmware() throws JposException {
        return false;
    }

    @Override
    public int getCapRecRuledLine() throws JposException {
        return 0;
    }

    @Override
    public int getCapSlpRuledLine() throws JposException {
        return 0;
    }

    @Override
    public boolean getAsyncMode() throws JposException {
        return this.m_asyncMode;
    }

    @Override
    public void setAsyncMode(boolean var1) throws JposException {
        this.m_asyncMode = var1;
    }

    @Override
    public int getCharacterSet() throws JposException {
        return this.m_recPrinterFont.getCharacterSet();
    }

    @Override
    public void setCharacterSet(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        this.m_recPrinterFont.setCharacterSet(var1);
    }

    @Override
    public String getCharacterSetList() throws JposException {
        return this.m_recPrinterFont.getCharacterSetList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCoverOpen() throws JposException {
        this.verifyDeviceEnabledState();
        PrinterStatus[] var1 = this.m_cachedStatus;
        PrinterStatus[] printerStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_cachedStatus[0].coverOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getErrorLevel() throws JposException {
        int[] var1 = this.m_serviceState;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_errorLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getErrorStation() throws JposException {
        int[] var1 = this.m_serviceState;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            if (1 == this.m_errorLevel) {
                throw new JposException(106, "This request failed because an error was not detected.");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getErrorString() throws JposException {
        int[] var1 = this.m_serviceState;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_errorString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getFlagWhenIdle() throws JposException {
        int[] var1 = this.m_serviceState;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_flagWhenIdle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlagWhenIdle(boolean var1) throws JposException {
        int[] var2 = this.m_serviceState;
        int[] nArray = this.m_serviceState;
        synchronized (this.m_serviceState) {
            this.m_flagWhenIdle = var1;
            if (this.m_flagWhenIdle && this.getState() == 2) {
                this.addEvent(new StatusUpdateEvent(this, 1001));
                this.m_flagWhenIdle = false;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String getFontTypefaceList() throws JposException {
        return "";
    }

    @Override
    public boolean getJrnEmpty() throws JposException {
        return false;
    }

    @Override
    public boolean getJrnLetterQuality() throws JposException {
        return false;
    }

    @Override
    public void setJrnLetterQuality(boolean var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public int getJrnLineChars() throws JposException {
        return 0;
    }

    @Override
    public void setJrnLineChars(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public String getJrnLineCharsList() throws JposException {
        return "";
    }

    @Override
    public int getJrnLineHeight() throws JposException {
        return 0;
    }

    @Override
    public void setJrnLineHeight(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public int getJrnLineSpacing() throws JposException {
        return 0;
    }

    @Override
    public void setJrnLineSpacing(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public int getJrnLineWidth() throws JposException {
        return 0;
    }

    @Override
    public boolean getJrnNearEnd() throws JposException {
        return false;
    }

    @Override
    public int getMapMode() throws JposException {
        return this.m_recMapMode.getMapMode();
    }

    @Override
    public void setMapMode(int var1) throws JposException {
        this.m_recMapMode.setMapMode(var1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutputID() throws JposException {
        Object var1 = this.m_asyncOutputLock;
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            return this.m_outputId;
        }
    }

    @Override
    public String getRecBarCodeRotationList() throws JposException {
        return "0,180";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getRecEmpty() throws JposException {
        this.verifyDeviceEnabledState();
        PrinterStatus[] var1 = this.m_cachedStatus;
        PrinterStatus[] printerStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_cachedStatus[0].receiptPaperEmpty;
        }
    }

    @Override
    public boolean getRecLetterQuality() throws JposException {
        return this.m_recLetterQuality;
    }

    @Override
    public void setRecLetterQuality(boolean var1) throws JposException {
        this.verifyDeviceEnabledState();
        this.m_recLetterQuality = var1;
    }

    @Override
    public int getRecLineChars() throws JposException {
        return this.m_recPrinterFont.getLineChars();
    }

    @Override
    public void setRecLineChars(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        this.m_recPrinterFont.setLineChars(var1);
    }

    @Override
    public String getRecLineCharsList() throws JposException {
        return this.m_recPrinterFont.getLineCharsList();
    }

    @Override
    public int getRecLineHeight() throws JposException {
        return this.m_recMapMode.dotToMapMode(24, this.m_recDotDimensionHeight);
    }

    @Override
    public void setRecLineHeight(int var1) throws JposException {
        this.verifyDeviceEnabledState();
    }

    @Override
    public int getRecLineSpacing() throws JposException {
        return this.m_recMapMode.dotToMapMode(this.m_recPrinterFont.getDotLineSpacing(), this.m_recDotDimensionHeight);
    }

    @Override
    public void setRecLineSpacing(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        this.m_recPrinterFont.setDotLineSpacing(this.m_recMapMode.mapModeToDot(var1, this.m_recDotDimensionHeight));
    }

    @Override
    public int getRecLinesToPaperCut() throws JposException {
        return this.m_recPrinterFont.getRecLinesToPaperCut();
    }

    @Override
    public int getRecLineWidth() throws JposException {
        return this.m_recMapMode.dotToMapMode(this.m_recPrinterFont.getLineWidthDot(), this.m_recDotDimensionWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getRecNearEnd() throws JposException {
        PrinterStatus[] var1 = this.m_cachedStatus;
        PrinterStatus[] printerStatusArray = this.m_cachedStatus;
        synchronized (this.m_cachedStatus) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.m_cachedStatus[0].receiptPaperNearEmptyInner;
        }
    }

    @Override
    public int getRecSidewaysMaxChars() throws JposException {
        return 0;
    }

    @Override
    public int getRecSidewaysMaxLines() throws JposException {
        return 0;
    }

    @Override
    public int getRotateSpecial() throws JposException {
        return this.m_recPrintMethods.getRotateSpecial();
    }

    @Override
    public void setRotateSpecial(int var1) throws JposException {
        this.m_recPrintMethods.setRotateSpecial(var1);
    }

    @Override
    public String getSlpBarCodeRotationList() throws JposException {
        return "";
    }

    @Override
    public boolean getSlpEmpty() throws JposException {
        this.verifyDeviceEnabledState();
        return false;
    }

    @Override
    public boolean getSlpLetterQuality() throws JposException {
        return false;
    }

    @Override
    public void setSlpLetterQuality(boolean var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public int getSlpLineChars() throws JposException {
        return 0;
    }

    @Override
    public void setSlpLineChars(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public String getSlpLineCharsList() throws JposException {
        return "";
    }

    @Override
    public int getSlpLineHeight() throws JposException {
        return 0;
    }

    @Override
    public void setSlpLineHeight(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public int getSlpLinesNearEndToEnd() throws JposException {
        return 0;
    }

    @Override
    public int getSlpLineSpacing() throws JposException {
        return 0;
    }

    @Override
    public void setSlpLineSpacing(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public int getSlpLineWidth() throws JposException {
        return 0;
    }

    @Override
    public int getSlpMaxLines() throws JposException {
        return 0;
    }

    @Override
    public boolean getSlpNearEnd() throws JposException {
        return false;
    }

    @Override
    public int getSlpSidewaysMaxChars() throws JposException {
        return 0;
    }

    @Override
    public int getSlpSidewaysMaxLines() throws JposException {
        return 0;
    }

    @Override
    public int getCartridgeNotify() throws JposException {
        return 0;
    }

    @Override
    public void setCartridgeNotify(int var1) throws JposException {
        if (var1 != 0) {
            throw new JposException(106, "This request failed because this device does not support cartidge notify.");
        }
    }

    @Override
    public int getJrnCartridgeState() throws JposException {
        return 0x10000000;
    }

    @Override
    public int getJrnCurrentCartridge() throws JposException {
        return 0;
    }

    @Override
    public void setJrnCurrentCartridge(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this cartidge.");
    }

    @Override
    public int getRecCartridgeState() throws JposException {
        return 0x10000000;
    }

    @Override
    public int getRecCurrentCartridge() throws JposException {
        return 0;
    }

    @Override
    public void setRecCurrentCartridge(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this cartidge.");
    }

    @Override
    public int getSlpCartridgeState() throws JposException {
        return 0x10000000;
    }

    @Override
    public int getSlpCurrentCartridge() throws JposException {
        return 0;
    }

    @Override
    public void setSlpCurrentCartridge(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request failed because this device does not support this cartidge.");
    }

    @Override
    public int getSlpPrintSide() throws JposException {
        return 0;
    }

    @Override
    public boolean getMapCharacterSet() throws JposException {
        return false;
    }

    @Override
    public void setMapCharacterSet(boolean var1) throws JposException {
        throw new JposException(106, "This request failed because this device does not support MapCharacterSet.");
    }

    @Override
    public String getRecBitmapRotationList() throws JposException {
        return "0,180";
    }

    @Override
    public String getSlpBitmapRotationList() throws JposException {
        return "";
    }

    @Override
    public String getPageModeArea() throws JposException {
        return "";
    }

    @Override
    public int getPageModeDescriptor() throws JposException {
        return 0;
    }

    @Override
    public int getPageModeHorizontalPosition() throws JposException {
        return 0;
    }

    @Override
    public void setPageModeHorizontalPosition(int var1) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    @Override
    public String getPageModePrintArea() throws JposException {
        return "";
    }

    @Override
    public void setPageModePrintArea(String var1) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    @Override
    public int getPageModePrintDirection() throws JposException {
        return 0;
    }

    @Override
    public void setPageModePrintDirection(int var1) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    @Override
    public int getPageModeStation() throws JposException {
        return 0;
    }

    @Override
    public void setPageModeStation(int var1) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    @Override
    public int getPageModeVerticalPosition() throws JposException {
        return 0;
    }

    @Override
    public void setPageModeVerticalPosition(int var1) throws JposException {
        throw new JposException(106, "This request failed because this device does not support PageMode.");
    }

    @Override
    public void beginInsertion(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    @Override
    public void beginRemoval(int var1) throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearOutput() throws JposException {
        this.verifyClaimedState();
        if (null != this.m_transactionOutputQueue) {
            this.m_transactionOutputQueue = null;
            this.m_transaction = false;
        }
        this.m_recPrintMethods.setRotatePrint(1);
        Object var1 = this.m_asyncOutputLock;
        Object object = this.m_asyncOutputLock;
        synchronized (object) {
            this.m_clearOutputPending = true;
            while (this.m_processingAsyncOutput) {
                try {
                    if (!this.m_clearOutputPending) {
                        this.m_processingAsyncOutput = false;
                        continue;
                    }
                    this.m_asyncOutputLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (null != this.m_asyncOutputQueue) {
                this.m_asyncOutputQueue.clear();
            }
        }
        var1 = this.m_eventLock;
        object = this.m_eventLock;
        synchronized (object) {
            Enumeration var2 = this.m_eventQueue.elements();
            while (true) {
                if (!var2.hasMoreElements()) break;
                this.m_eventQueue.clear();
            }
            this.setServiceState(2);
        }
        var1 = this.m_asyncOutputLock;
        object = this.m_asyncOutputLock;
        synchronized (object) {
            this.m_clearOutputPending = false;
            this.m_asyncOutputLock.notifyAll();
        }
    }

    @Override
    public void cutPaper(int var1) throws JposException {
        ArrayList<byte[]> var2 = new ArrayList<byte[]>();
        this.verifyDeviceEnabledState();
        if (!this.m_asyncMode) {
            if (2 != this.getState()) {
                throw new JposException(113, "This request is illegal because the service is busy processing asynchronous output.");
            }
            if (this.m_cachedStatus[0].coverOpen) {
                throw new JposException(114, 201, "This request is illegal because the cover is opened.");
            }
            if (this.m_cachedStatus[0].receiptPaperEmpty) {
                throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
            }
        }
        var2.add(this.m_recPrintMethods.paperCutCommand(var1, false, true));
        if (this.m_transaction) {
            this.m_transactionOutputQueue.add(var2);
        } else if (this.m_asyncMode) {
            this.addAsyncOutput(var2);
        } else {
            this.outputData(var2);
        }
    }

    @Override
    public void endInsertion() throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    @Override
    public void endRemoval() throws JposException {
        this.verifyDeviceEnabledState();
        throw new JposException(106, "This request is illegal because the specified station is unsupported.");
    }

    @Override
    public void printBarCode(int receiptType, String barcodeData, int codeType, int barHeight, int barWidth, int alignmentMode, int textPlace) throws JposException {
        List outDataList = null;
        this.verifyDeviceEnabledState();
        if (2 != receiptType) {
            throw new JposException(106, "This request is illegal because the specified station is unsupported.");
        }
        if (!this.m_asyncMode) {
            if (2 != this.getState()) {
                throw new JposException(106, "This request is illegal because the service is busy processing asynchronous output.");
            }
            if (this.m_cachedStatus[0].coverOpen) {
                throw new JposException(114, 201, "This request is illegal because the cover is opened.");
            }
            if (this.m_cachedStatus[0].receiptPaperEmpty) {
                throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
            }
        }
        if (0 >= barHeight) {
            throw new JposException(106, "This request failed because the height parameter is not valid.");
        }
        barHeight = this.m_recMapMode.mapModeToDot(barHeight, this.m_recDotDimensionHeight);
        if (0 >= barWidth) {
            throw new JposException(106, "This request failed because the width parameter is not valid.");
        }
        barWidth = this.m_recMapMode.mapModeToDot(barWidth, this.m_recDotDimensionWidth);
        if (alignmentMode != -1 && alignmentMode != -2 && alignmentMode != -3) {
            if (0 > alignmentMode) {
                throw new JposException(106, "This request failed because the aligment parameter is not valid.");
            }
            alignmentMode = this.m_recMapMode.mapModeToDot(alignmentMode, this.m_recDotDimensionWidth);
        }
        outDataList = this.m_recPrintMethods.barCodeCommand(barcodeData, codeType, barHeight, barWidth, alignmentMode, textPlace);
        if (this.m_transaction) {
            this.m_transactionOutputQueue.add(outDataList);
        } else if (this.m_asyncMode) {
            this.addAsyncOutput(outDataList);
        } else {
            this.outputData(outDataList);
        }
    }

    @Override
    public void printBitmap(int var1, String var2, int var3, int var4) throws JposException {
        List var5 = null;
        Image var6 = null;
        this.verifyDeviceEnabledState();
        if (2 != var1) {
            throw new JposException(106, "This request is illegal because the specified station is unsupported.");
        }
        if (!this.m_asyncMode) {
            if (2 != this.getState()) {
                throw new JposException(106, "This request is illegal because the service is busy processing asynchronous output.");
            }
            if (this.m_cachedStatus[0].coverOpen) {
                throw new JposException(114, 201, "This request is illegal because the cover is opened.");
            }
            if (this.m_cachedStatus[0].receiptPaperEmpty) {
                throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
            }
        }
        if (-11 != var3) {
            if (0 > var3) {
                throw new JposException(106, "This request failed because the width parameter is not valid.");
            }
            var3 = this.m_recMapMode.mapModeToDot(var3, this.m_recDotDimensionWidth);
        }
        if (-1 != var4 && -2 != var4 && -3 != var4) {
            if (0 > var4) {
                throw new JposException(106, "This request failed because the aligment parameter is not valid.");
            }
            var4 = this.m_recMapMode.mapModeToDot(var4, this.m_recDotDimensionWidth);
        }
        try {
            var6 = var2.toLowerCase().endsWith(".bmp") ? BMPImageProcessor.getImageFromBMPFile(var2) : new ImageIcon(var2).getImage();
        }
        catch (Exception var8) {
            throw new JposException(109);
        }
        if (259 == this.m_recPrintMethods.getRotateBitmap()) {
            var5 = this.m_recPrintMethods.bitmapCommand(var6, var3, var4, 259);
        } else {
            if (1 != this.m_recPrintMethods.getRotateBitmap()) {
                throw new JposException(106);
            }
            var5 = this.m_recPrintMethods.bitmapCommand(var6, var3, var4, 1);
        }
        if (this.m_transaction) {
            this.m_transactionOutputQueue.add(var5);
        } else if (this.m_asyncMode) {
            this.addAsyncOutput(var5);
        } else {
            this.outputData(var5);
        }
    }

    @Override
    public void printImmediate(int var1, String var2) throws JposException {
        List var3 = null;
        this.verifyDeviceEnabledState();
        if (2 != var1) {
            throw new JposException(106, "This request is illegal because the specified station is unsupported.");
        }
        if (this.m_cachedStatus[0].coverOpen) {
            throw new JposException(114, 201, "This request is illegal because the cover is opened.");
        }
        if (this.m_cachedStatus[0].receiptPaperEmpty) {
            throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
        }
        var3 = this.m_recPrintMethods.parseEscapeSequences(0, var2, false);
        this.outputData(var3);
    }

    @Override
    public void printNormal(int var1, String var2) throws JposException {
        List var3 = null;
        this.verifyDeviceEnabledState();
        if (2 != var1) {
            throw new JposException(106, "This request is illegal because the specified station is unsupported.");
        }
        if (!this.m_asyncMode) {
            if (2 != this.getState()) {
                throw new JposException(113, "This request is illegal because the service is busy processing asynchronous output.");
            }
            if (this.m_cachedStatus[0].coverOpen) {
                throw new JposException(114, 201, "This request is illegal because the cover is opened.");
            }
            if (this.m_cachedStatus[0].receiptPaperEmpty) {
                throw new JposException(114, 203, "This request is illegal because the receipt paper is empty.");
            }
        }
        var3 = this.m_recPrintMethods.parseEscapeSequences(0, var2, false);
        if (this.m_transaction) {
            this.m_transactionOutputQueue.add(var3);
        } else if (this.m_asyncMode) {
            this.addAsyncOutput(var3);
        } else {
            this.outputData(var3);
        }
    }

    @Override
    public void printTwoNormal(int var1, String var2, String var3) throws JposException {
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public void rotatePrint(int var1, int var2) throws JposException {
        this.verifyDeviceEnabledState();
        if (2 != var1) {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
        this.m_recPrintMethods.setRotatePrint(var2);
    }

    @Override
    public void setBitmap(int var1, int var2, String var3, int var4, int var5) throws JposException {
        this.verifyDeviceEnabledState();
        if (!this.getCapRecBitmap()) {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
        if (2 == var2) {
            if (-11 != var4) {
                this.m_recPrintMethods.setBitmap(var1, var3, this.m_recMapMode.mapModeToDot(var4, this.m_recDotDimensionWidth), var5);
            } else {
                this.m_recPrintMethods.setBitmap(var1, var3, var4, var5);
            }
        } else {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
    }

    @Override
    public void setLogo(int var1, String var2) throws JposException {
        this.verifyDeviceEnabledState();
        if (1 != var1 && 2 != var1) {
            throw new JposException(106, "This request failed because the specified logo location is invalid.");
        }
        this.m_recPrintMethods.setLogo(var1, var2);
    }

    @Override
    public void transactionPrint(int var1, int var2) throws JposException {
        this.verifyDeviceEnabledState();
        if (2 != var1) {
            throw new JposException(106, "This request failed because this request is not supported this print station.");
        }
        if (!this.m_asyncMode && 2 != this.getState()) {
            throw new JposException(106, "This request is illegal because the service is busy processing asynchronous output.");
        }
        if (11 == var2) {
            if (null != this.m_transactionOutputQueue) {
                throw new JposException(106, "This request is illegal because a transaction is already in progress.");
            }
            this.m_transactionOutputQueue = new ArrayList();
            this.m_transaction = true;
        } else {
            if (null == this.m_transactionOutputQueue) {
                throw new JposException(106, "This request is illegal because a transaction is not in progress.");
            }
            ArrayList<byte[]> var3 = new ArrayList<byte[]>();
            List var4 = null;
            while (!this.m_transactionOutputQueue.isEmpty()) {
                var4 = (List)this.m_transactionOutputQueue.remove(0);
                while (!var4.isEmpty()) {
                    var3.add((byte[])var4.remove(0));
                }
            }
            if (this.m_asyncMode) {
                this.addAsyncOutput(var3);
            } else {
                this.outputData(var3);
            }
            this.m_transactionOutputQueue = null;
            this.m_transaction = false;
        }
    }

    @Override
    public void validateData(int var1, String var2) throws JposException {
        this.verifyDeviceEnabledState();
        if (2 != var1) {
            throw new JposException(106, "This request failed because the specified print station does not support this operation.");
        }
        if (!this.m_asyncMode && 2 != this.getState()) {
            throw new JposException(106, "This request is illegal because the service is busy processing asynchronous output.");
        }
        this.m_recPrintMethods.parseEscapeSequences(0, var2, true);
    }

    @Override
    public void changePrintSide(int var1) throws JposException {
        throw new JposException(106, "This request failed because this device does not support this print station.");
    }

    @Override
    public void markFeed(int var1) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void resetStatistics(String var1) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void retrieveStatistics(String[] var1) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void updateStatistics(String var1) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void clearPrintArea() throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void compareFirmwareVersion(String var1, int[] var2) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void pageModePrint(int var1) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void updateFirmware(String var1) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void printMemoryBitmap(int var1, byte[] var2, int var3, int var4, int var5) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }

    @Override
    public void drawRuledLine(int var1, String var2, int var3, int var4, int var5, int var6) throws JposException {
        throw new JposException(106, "This function is not supported.");
    }
}

