unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Menus, AfDataDispatcher, AfComPort, AfComPortCore,
  Spin, Registry, Inifiles, GraphicEx, AfPortControls;


type TTMTyp = ( tmFullRange, tmRoom, tmOutDor, tmRefridge ) ;

const TMLow : array[tmFullRange..tmRefridge] of Integer    = ( -55,  10,  -15,  -30 );
      TMHigh: array[tmFullRange..tmRefridge] of Integer    = ( 125,  35,   35,   10 );
      TMiTop   : array[tmFullRange..tmRefridge] of Integer = (  64,  73,   94,   90 );
      TMiBottom: array[tmFullRange..tmRefridge] of Integer = ( 425,  425, 395,  411 );
      RX=451 ;

type
  TfMain = class(TForm)
    TMa: TImage;
    iBackground: TImage;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Image4: TImage;
    AfComPort1: TAfComPort;
    Image5: TImage;
    Panel1: TPanel;
    iRtut: TImage;
    TMb: TImage;
    TMc: TImage;
    Tmd: TImage;
    Iteplomer: TImage;
    MainMenu1: TMainMenu;
    Typteplomru1: TMenuItem;
    mComy: TMenuItem;
    mF1: TMenuItem;
    mF2: TMenuItem;
    mF3: TMenuItem;
    mF4: TMenuItem;
    Timer1: TTimer;
    File1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure AfComPort1NonSyncEvent(Sender: TObject; EventKind: TAfCoreEvent; Data: Cardinal);
    procedure plnrozsah1Click(Sender: TObject);
    procedure COMClick(Sender: TObject);
    procedure mComyClick(Sender: TObject);
    procedure AktualizaceZobrazeni;
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure AfComPort1PortOpen(Sender: TObject);
  private
    { Private declarations }
    sBuf : string;
    procedure ComyUpdate;
  public
    { Public declarations }
    procedure SaveToFile;
  end;

function GradientFill(DC : hDC; pVertex : Pointer; dwNumVertex : DWORD;
  pMesh : Pointer; dwNumMesh, dwMode: DWORD) : DWord; stdcall;
  external 'msimg32.dll';

var
  fMain : TfMain;
  TMTyp : TTMTyp ;
  Value : Real ;
  lastMereni : TDateTime ;

implementation

{$R *.DFM}

const
  PS_OPEN     = 0;
  PS_CLOSE    = 1;
  PS_NOTEXIST = 2;

type
  TPortState = packed record
    ComNumber: Word;
    State: Word;
  end;

function GetPortState(PortNumber: Integer): TPortState;
var
  DeviceHandle: THandle;
  DeviceName: String;
begin
  Result.ComNumber := PortNumber;

  if Win32Platform=VER_PLATFORM_WIN32_NT
   then DeviceName := Format('\\.\COM%d', [PortNumber])
   else DeviceName := Format('COM%d',[PortNumber]);
  DeviceHandle := CreateFile(PChar(DeviceName), GENERIC_READ or GENERIC_WRITE,
    0, nil, OPEN_EXISTING, 0, 0);
  if DeviceHandle = INVALID_HANDLE_VALUE then
  begin
    if GetLastError = ERROR_FILE_NOT_FOUND then
      Result.State := PS_NOTEXIST
    else
      Result.State := PS_OPEN;
  end else
  begin
    CloseHandle(DeviceHandle);
    Result.State := PS_CLOSE;
  end;
end;

Function GetComNumber(s:String):Integer ;
var i:Integer;
begin
  i:=1;
  result:= -1 ;
  try
    while (length(s)>=i) and (Pos(s[i],'0123456789')=0) do delete(s,i,1);
    while Pos('&',S)<>0 do Delete(S,Pos('&',S),1);
    Result:=StrToInt(s);
  except
  end ;
end ;

procedure TfMain.FormCreate(Sender: TObject);
Var
  Y : Integer ;
  fIni : TIniFile ;
  DC : HDC ;
begin
  value := -100 ;
  fMain.Width := 798 ;
  fMain.Height := 574 ;
  iRtut.Left := Iteplomer.Left + 53 ;
  Iteplomer.Top := 25 ;
  Iteplomer.Left := 41 ;
  Iteplomer.Width := TMa.Width ;
  Iteplomer.Height := TMa.Height ;
  Panel1.Top := 98 ;
  Panel1.Left := 227 ;
  Panel1.Height := 81 ;
  Panel1.Width := 385 ;
  Image1.Left := 200 ;
  Image1.Top := 368 ;
  Image2.Left := 583 ;
  Image2.Top := 260 ;
  Image3.Left := 766 ;
  Image3.Top := -24 ;
  Image4.Left := 544 ;
  Image4.Top := 479 ;
  Image5.Left := 207 ;
  Image5.Top := 69 ;

  DC := GetDC(0);
  Panel1.Font.Size := round(96*58/GetDeviceCaps(DC, LOGPIXELSX));
  ReleaseDC(0,DC);

  AktualizaceZobrazeni ;

  ComyUpdate;

  fIni := TIniFile.Create(ExtractFilePath(Application.ExeName)+'teplomer.ini');
  AfComPort1.ComNumber:=fIni.ReadInteger('Komunikace', 'Port', 1);
  If GetPortState(AfComPort1.ComNumber).State=PS_CLOSE then AfComPort1.Open;
  fIni.Free ;
end;

procedure TfMain.AfComPort1NonSyncEvent(Sender: TObject;
  EventKind: TAfCoreEvent; Data: Cardinal);
var val:extended;
    i:integer;
begin
  If (DATA AND Not(EV_RXCHAR)=0) AND (EventKind=ceLineEvent) then
  begin
    sBuf:=sBuf+AfComPort1.ReadString;
    while Pos(#13,sBuf)<>0 do
    begin
      i:=1;
      While (sBuf<>'') and (Pos(sBuf[1],'+-')=0) do delete(sBuf,1,1);
      if (sBuf<>'') and (sBuf[1]='+') then Delete(sBuf,1,1);

      While (Length(sBuf)>=i) and (Pos(sBuf[i],'-0123456789,.')<>0) do inc(i);

      case DecimalSeparator of
       ',': While Pos('.', sBuf)<>0 do sBuf[Pos('.',sBuf)]:=',';
       '.': While Pos(',', sBuf)<>0 do sBuf[Pos(',',sBuf)]:='.';
      end;

      if TryStrToFloat(copy(sBuf,1,i-1),val) then
      begin
        Value := val;
        LastMereni := Now ;

        SaveToFile;

        AktualizaceZobrazeni;
      end;

      Delete(sBuf,1,pos(#13,sBuf));
    end;

{
    If (Length(sBuf)=8) and (sBuf[length(sBuf)]=#13) then
    begin
      delete(sBuf,Pos('C',sBuf),length(sBuf)-Pos('C',sBuf)+1);
      If Pos('.', sBuf)<>0 then sBuf[Pos('.',sBuf)]:=Decimalseparator;
      If Pos(',', sBuf)<>0 then sBuf[Pos(',',sBuf)]:=Decimalseparator;
      Value := StrToFloat(sBuf);
      LastMereni := Now ;
      AktualizaceZobrazeni;
    end ;
}
  end ;
end;

procedure TfMain.plnrozsah1Click(Sender: TObject);
begin
  mF1.Checked:=false ;
  mF2.Checked:=false;
  mF3.Checked:=false;
  mF4.checked:=false;
  (Sender as TMenuItem).Checked := True ;
  Case (sender as TMenuItem).Tag of
   0: begin
        TMTyp:=tmFullRange;
        Iteplomer.Canvas.Draw(0,0,TMa.Picture.Graphic);
      end ;
   1: begin
        TMTyp:=tmRoom;
        Iteplomer.Canvas.Draw(0,0,TMb.Picture.Graphic);
      end ;
   2: begin
        TMTyp:=tmOutDor;
        Iteplomer.Canvas.Draw(0,0,TMc.Picture.Graphic);
      end ;
   3: begin
        TMTyp:=tmRefridge;
        Iteplomer.Canvas.Draw(0,0,TMd.Picture.Graphic);
      end ;
  end ;
  AktualizaceZobrazeni;
end;

procedure TfMain.COMClick(Sender: TObject);
Var
  I : Integer ;
  fIni : TiniFile;
begin
  For I:= 1 to mComy.Count do mComy.Items[I-1].Checked:=false;

  AfComPort1.Close ;
  AfComPort1.ComNumber := GetComNumber((sender as TMenuItem).Caption);
  AfComPort1.Open ;
  Value := -100 ;
  AktualizaceZobrazeni;
  panel1.Caption:='-';
  (sender as tMenuItem).Checked:=AfComPort1.Active;
  FIni := TIniFile.Create(ExtractFilePath(Application.ExeName)+'teplomer.ini') ;
  fini.WriteInteger('Komunikace', 'Port', AfComPort1.ComNumber);
  fini.Free ;
end;

procedure TfMain.mComyClick(Sender: TObject);
Var I : Integer ;
begin
  For I:=1 to mComy.Count do
  begin
    mComy.Items[I-1].Checked := AfComPort1.Active and (AfComPort1.ComNumber=GetComNumber(mComy.Items[I-1].Caption));
    mComy.Items[I-1].Enabled := (GetPortState(GetComNumber(mComy.Items[I-1].Caption)).State=PS_CLOSE) or (mComy.Items[I-1].Checked);
  end ;
end;

procedure TfMain.AktualizaceZobrazeni;
Var X : integer;
begin
  X:=0 ;

  if Value < -99 then
  begin
    panel1.Caption := 'disconnected';
    panel1.Font.Size:=39;
  end
  else
  begin
    Panel1.Caption := Format('%2.1f C', [Value]);
    panel1.Font.Size:=45;
  end;

  If Value<TMLow[tmtyp] then X:=5 else
   If Value>TMHigh[tmtyp] then X:=385 else
    X:= Round ((TMiBottom[TMTyp]-TMiTop[TMTyp])/(TMHigh[TMTyp]-TMLow[TMTyp])*(Value-TMLow[TMTyp])+Rx-TMiBottom[TMTyp]) ;

  if Value < -99 then X:=0;

  iRtut.Top    := Rx - X;
  iRtut.Height := X;
end;

procedure TfMain.Timer1Timer(Sender: TObject);
begin
  if LastMereni+EncodeTime(0,0,10,0)<Now then
  begin
    Value := -100 ;
    AktualizaceZobrazeni;
  end;
end;



procedure TfMain.FormShow(Sender: TObject);
Var Y : Integer ;

procedure GG;
type
  TRIVERTEX = packed record
    X, Y : DWORD;
    Red, Green, Blue, Alpha : Word;
  end;
var
 vert : array[0..1] of TRIVERTEX;
 gRect   : GRADIENT_RECT;
 A: cardinal;
begin
  vert [0] .x      := 0;
  vert [0] .y      := 0;
  vert [0] .Red    := $FF00;
  vert [0] .Green  := $6000;
  vert [0] .Blue   := $6000;
  vert [0] .Alpha  := $0000;

  vert[1].x      := iBackground.Width;
  vert[1].y      := iBackground.Height;
  vert[1].Red    := $6000;
  vert[1].Green  := $6000;
  vert[1].Blue   := $FF00;
  vert[1].Alpha  := $0000;

  gRect.UpperLeft  := 0;
  gRect.LowerRight := 1;

  A:=2;

  GradientFill(iBackground.Canvas.Handle, @vert,2,@gRect,1,GRADIENT_FILL_RECT_V);
end;
  begin
  Iteplomer.Canvas.Draw(0,0,TMa.Picture.Graphic);
  iBackground.Visible:=False;
{  For Y:=0 to iBackground.Height do
  begin
    GradientFill(iBackground,)

    iBackground.Canvas.pen.Color:=RGB( round (0  +((0-221)  /(iBackground.Height+1)*(Y+1))),   //R
                                       round (19 +((124-19) /(iBackground.Height+1)*(Y+1))),   //G
                                       round (123+((195-123)/(iBackground.Height+1)*(Y+1)))    //B
                                     );
    iBackground.Canvas.MoveTo(0,Y);
    iBackground.Canvas.LineTo(iBackground.Width,Y);
  end;}
  GG;
  iBackground.Visible:=True;
  DoubleBuffered:=True;
end;

procedure TfMain.ComyUpdate;
var
  reg: TRegistry;
  st : Tstrings;
  i  : Integer;
  tm : TMenuItem;
  Stat : word;
begin
  while mComy.Count>0 do mComy.Items[0].Free;
  mComy.Clear;

  for i:=1 to 255 do
  begin
    Stat:=GetPortState(i).State;

    if Stat<>PS_NOTEXIST then
    begin
      tm := TMenuItem.Create(nil);
      tm.Caption := 'COM'+IntToStr(I);
      tm.OnClick := COMClick ;
      mComy.Add(tm);
      tm.Enabled:=stat=PS_CLOSE;
      tm.Checked:=AfComPort1.ComNumber=i;
    end;

  end;

{  reg := TRegistry.Create;
  try
    reg.RootKey := HKEY_LOCAL_MACHINE;
    reg.OpenKey('hardware\devicemap\serialcomm', False);
    st := TstringList.Create;
    try
      reg.GetValueNames(st);
      for i := 0 to st.Count-1 do
      begin
        tm := TMenuItem.Create(nil);
        tm.Caption := reg.Readstring(st.strings[i]) ;
        tm.OnClick := COMClick ;
        mComy.Add(tm);
      end ;
    finally
      st.Free;
    end;
    reg.CloseKey;
  finally
    reg.Free;
  end;
  }
end;

procedure TfMain.AfComPort1PortOpen(Sender: TObject);
begin
  panel1.Caption:='-';
end;

procedure TfMain.SaveToFile;
var
  H:tHandle;
  s,T: String;
begin
  S:=ExtractFilePath(Application.ExeName)+FormatDateTime('YYYYMMDD',Now)+'.txt';
  if FileExists(S)
   then H:=FileOpen(S,fmOpenReadWrite)
   else H:=FileCreate(S);

  if H<>0 then
  begin
    T:=TimeToStr(Now)+' '+FloatToStr(Value)+#13#10;
    FileSeek(H,0,2);
    FileWrite(H,T[1],Length(t));
    FileClose(H);
  end;

end;

end.

