// WWW.ROBO.COM.CY
// DEMO CODE FOR PROGRAMMABLE STAR V2
// VERSION: 4
// DATE: 15/12/2020

//NEEDED LIBRARIES
#include "src/Adafruit_NeoPixel/Adafruit_NeoPixel.h"

//SWITCH TO 1 FOR SERIAL PRINT DEBUG
#define DEBUG 0

//PINOUT
#define LED_PIN 2
#define SW1 9
#define SW2 8
#define SW3 7
#define SW4 4

//CONSTANTS
#define LED_COUNT 6

//VARIABLES
Adafruit_NeoPixel star(LED_COUNT, LED_PIN, NEO_GRB + NEO_KHZ800);
int r,g,b,deg;
uint8_t mode; //STORES THE COMBINATION MADE BY THE 4 SWITCHES (0-15)

void setup() {
  Serial.begin(9600);

  pinMode(SW1,INPUT_PULLUP);
  pinMode(SW2,INPUT_PULLUP);
  pinMode(SW3,INPUT_PULLUP);
  pinMode(SW4,INPUT_PULLUP);
  
  star.begin();
}

void loop() {
  mode = !digitalRead(SW1)*8+!digitalRead(SW2)*4+!digitalRead(SW3)*2+!digitalRead(SW4);
  
  if(DEBUG){
    Serial.print(!digitalRead(SW1));
    Serial.print(!digitalRead(SW2));
    Serial.print(!digitalRead(SW3));
    Serial.print(!digitalRead(SW4));
    Serial.print(" -> "); 
    Serial.println(mode);
  }

  switch (mode) {
    case 0://BLUE COLOR SLOW FADE IN AND OUT
        for(int b=0;b<200;b++){
          setStarTo(0,0,b);
          delay(5);
        }
        for(int b=200;b>0;b--){
          setStarTo(0,0,b); 
          delay(5);
        }        
    break;
      
    case 1://RED COLOR FAST FADE IN AND SLOWER FADE OUT
        for(int r=0;r<200;r++){
          setStarTo(r,0,0);
          delay(1);
        }
        for(int r=200;r>0;r--){
          setStarTo(r,0,0); 
          delay(20);
        }          
    break;
      
    case 2://GREEN COLOR FAST FADE IN FAST FADE OUT. STAYS 2S OFF IN BETWEEN
        for(int g=0;g<200;g++){
          setStarTo(0,g,0);
          delay(1);
        }
        for(int g=200;g>=0;g--){
          setStarTo(0,g,0); 
          delay(1);
        }   
        delay(2000);     
    break;
          
    case 3://SLOWER PURPLE WHITE CIRCLING THROUGH LEDS 1-5
        for(int c=0; c<LED_COUNT-1; c++){
          turnStarOff();
          star.setPixelColor(c,255,0,150);
          star.show();
          delay(200);
        }
    break;

    case 4://FAST LIGHT WHITE CIRCLING THROUGH LEDS 1-5
        for(int c=0; c<LED_COUNT-1; c++){
          turnStarOff();
          star.setPixelColor(c,255,255,199);
          star.show();
          delay(35);
        }
    break; 

    case 5://SLOWER PURPLE WHITE CIRCLING THROUGH LEDS 1-5
        for(int c=0; c<LED_COUNT-1; c++){
          turnStarOff();
          star.setPixelColor(5,100,0,180);
          star.setPixelColor(c,100,0,180);
          star.show();
          delay(20);
        }
    break;
      
    case 6://RANDOM COLOR CIRCLING THOUGH LEDS 1-5
        r = random(0, 150);
        g = random(0, 150);
        b = random(0, 150);
        for(int c=0; c<LED_COUNT-1; c++){
          turnStarOff();
          star.setPixelColor(c,r,g,b);
          star.show();
          delay(100);
        }
    break;

    case 7://RANDOM COLOR CIRCLING THOUGH LEDS 1-5. PREVIOUS LED STAYS ON
        r = random(0, 120);
        g = random(0, 120);
        b = random(0, 120);
        for(int c=0; c<LED_COUNT-1; c++){
          star.setPixelColor(c,r,g,b);
          star.show();
          delay(100);
          if(c>0){
            star.setPixelColor(c-1,0,0,0);
            delay(100);
            star.show();
          }
        }
    break;
      
    case 8://RANDOM COLOR CIRCLING THOUGH LEDS 1-5. PREVIOUS LED STAYS ON
        r = random(0, 120);
        g = random(0, 120);
        b = random(0, 120);
        for(int c=0; c<LED_COUNT-1; c++){
          star.setPixelColor(c,r,g,b);
          star.show();
          delay(100);
        }
    break;
      
    case 9://YELLOW COLOR CIRCLING THOUGH LEDS 1-5 WITH SLOW FADE IN AND OUT
        for(int c=0; c<LED_COUNT-1; c++){
          turnStarOff();
          for(int r=0; r<200; r++){
            star.setPixelColor(c,r,r,0);
            star.show();
            delay(1);
          }
          for(int r=200; r>0; r--){
            star.setPixelColor(c,r,r,0);
            star.show();
            delay(1);
          }       
          delay(100);    
        }
    break;
      
    case 10://RANDOM LED ON 1-6 AT RANDOM POSITION
        turnStarOff();
        delay(400);
        for(int c=0;c<LED_COUNT-1;c++){
          star.setPixelColor(c, random(0, 255), random(0, 255), random(0, 255));
          star.show();
          delay(400);
        }   
    break;
        
    case 11://FADE IN FADE OUT WITH RANDOM COLOR
        deg = random(0, 360);   
        for(int intensity=0;intensity<200;intensity++){
          setStarToDeg(deg,intensity);
          delay(5);
        }
        for(int intensity=200;intensity>=0;intensity--){
          setStarToDeg(deg,intensity);
          delay(5);
        }
    break;
        
    case 12://FADE IN FADE OUT WITH RANDOM COLOR AND RANDOM LED
        {
          turnStarOff();
          deg = random(0, 360);
          int led = random(0, LED_COUNT-1);    
          for(int intensity=0;intensity<200;intensity++){
            setLedToDeg(deg,intensity,led);
            star.show();
            delay(5);
          }
          for(int intensity=200;intensity>0;intensity--){
            setLedToDeg(deg,intensity,led);
            star.show(); 
            delay(5);
          }
        }
    break;  

    case 13://RANDOM STAR COLOR EVERY 1S
      deg = random(0, 360);
      setStarToDeg(deg,100);
      delay(1000);
    break;

    case 14://FAST ALL LEDS ON LOOPING THROUGH ALL THE COLORS
      for(int d=0;d<360;d++){
        setStarToDeg(d,200);
        star.show();
        delay(5);
      }          
    break; 

    case 15://FAST RANDOM COLOR AT RANDOM POSITION
      turnStarOff();
      star.setPixelColor(random(0, LED_COUNT), random(0, 255), random(0, 255), random(0, 255));
      star.show();
      delay(20);
    break;  
              
    default:
      turnStarOff();
    break;
  }

  delay(1);
}

void setLedToDeg(int d, int intensity, int led){
  if(0<d && d<60)
    star.setPixelColor(led,intensity,map(d,0,60,0,intensity),0);
  else if(60<d && d<120)
    star.setPixelColor(led,map(d,60,120,intensity,0),intensity,0);
  else if(120<d && d<180)
    star.setPixelColor(led,0,intensity,map(d,120,180,0,intensity));
  else if(180<d && d<240)
    star.setPixelColor(led,0,map(d,180,240,intensity,0),intensity);
  else if(240<d && d<300)
    star.setPixelColor(led,map(d,240,300,0,intensity),0,intensity);
  else if(300<d && d<360)
    star.setPixelColor(led,intensity,0,map(d,300,360,intensity,0)); 
}

void setStarToDeg(int d, int intensity){
  if(0<d && d<60)
    setStarTo(intensity,map(d,0,60,0,intensity),0);
  else if(60<d && d<120)
    setStarTo(map(d,60,120,intensity,0),intensity,0);
  else if(120<d && d<180)
    setStarTo(0,intensity,map(d,120,180,0,intensity));
  else if(180<d && d<240)
    setStarTo(0,map(d,180,240,intensity,0),intensity);
  else if(240<d && d<300)
    setStarTo(map(d,240,300,0,intensity),0,intensity);
  else if(300<d && d<360)
    setStarTo(intensity,0,map(d,300,360,intensity,0));
}

void setStarTo(int r, int g, int b){
   for(int c=0; c<LED_COUNT; c++){
    star.setPixelColor(c, r, g, b);
    star.show();
  }
}

void turnStarOff(){
   for(int c=0; c<LED_COUNT; c++){
    star.setPixelColor(c, 0, 0, 0);
    star.show();
  }
}
